/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.jpmml.rexp.RDataOutput;
import org.jpmml.rexp.RFactorVector;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RString;
import org.jpmml.rexp.RVector;

public class RStringVector
extends RVector<String> {
    private List<String> values = null;
    public static final RStringVector EMPTY = new RStringVector(Collections.emptyList(), null);
    private static final Function<String, String> FUNCTION_DEQUOTE = new Function<String, String>(){

        public String apply(String string) {
            if (string.length() > 1 && string.charAt(0) == '`' && string.charAt(string.length() - 1) == '`') {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }
    };

    public RStringVector(String value, RPair attributes) {
        this(Collections.singletonList(value), attributes);
    }

    public RStringVector(List<String> values, RPair attributes) {
        super(attributes);
        this.setValues(values);
    }

    @Override
    int type() {
        return 16;
    }

    @Override
    void writeValues(RDataOutput output) throws IOException {
        List<String> values = this.getValues();
        int length = values.size();
        output.writeInt(length);
        for (int i = 0; i < length; ++i) {
            RString string = new RString(values.get(i));
            string.write(output);
        }
    }

    @Override
    public DataType getDataType() {
        return DataType.STRING;
    }

    public RFactorVector toFactorVector() {
        List<String> values = this.getValues();
        List<String> levels = values.stream().distinct().sorted(Comparator.nullsLast(Comparator.naturalOrder())).collect(Collectors.toList());
        return this.toFactorVector(levels);
    }

    public RFactorVector toFactorVector(List<String> levels) {
        List<String> values = this.getValues();
        int[] levelValues = values.stream().mapToInt(value -> {
            int index = levels.indexOf(value);
            if (index < 0) {
                return Integer.MIN_VALUE;
            }
            return index + 1;
        }).toArray();
        RFactorVector result = new RFactorVector(levelValues, null);
        result.addAttribute("class", new RStringVector(Arrays.asList("factor"), null));
        result.addAttribute("levels", new RStringVector(levels, null));
        return result;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public String getDequotedValue(int i) {
        return (String)FUNCTION_DEQUOTE.apply((Object)this.getValue(i));
    }

    @Override
    public String getValue(int index) {
        return this.values.get(index);
    }

    public List<String> getDequotedValues() {
        return Lists.transform(this.getValues(), FUNCTION_DEQUOTE);
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    private void setValues(List<String> values) {
        this.values = values;
    }
}

