/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.core.ssf.univariate.ISsfData;

public class SsfDataWindow
implements ISsfData {
    private final int start;
    private final int end;
    private final int n;
    private final ISsfData data;

    public SsfDataWindow(ISsfData data, int start, int end) {
        this.data = data;
        this.start = start;
        this.end = end;
        this.n = data.length();
    }

    public double get(int pos) {
        int npos = pos + this.start;
        return npos < this.n ? this.data.get(npos) : Double.NaN;
    }

    @Override
    public boolean isMissing(int pos) {
        int npos = pos + this.start;
        return npos < this.n ? this.data.isMissing(npos) : true;
    }

    public int length() {
        return this.end - this.start;
    }
}

