% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrids.R
\name{setPhenoGCA}
\alias{setPhenoGCA}
\title{Set GCA as phenotype}
\usage{
setPhenoGCA(
  pop,
  testers,
  use = "pheno",
  h2 = NULL,
  H2 = NULL,
  varE = NULL,
  corE = NULL,
  reps = 1,
  fixEff = 1L,
  p = NULL,
  inbred = FALSE,
  onlyPheno = FALSE,
  simParam = NULL
)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{testers}{an object of \code{\link{Pop-class}}}

\item{use}{true genetic value (\code{gv}) or phenotypes (\code{pheno}, default)}

\item{h2}{a vector of desired narrow-sense heritabilities for
each trait. See details in \code{\link{setPheno}}.}

\item{H2}{a vector of desired broad-sense heritabilities for
each trait. See details in \code{\link{setPheno}}.}

\item{varE}{error (co)variances for traits.
See details in \code{\link{setPheno}}.}

\item{corE}{an optional matrix for correlations between errors.
See details in \code{\link{setPheno}}.}

\item{reps}{number of replications for phenotype.
See details in \code{\link{setPheno}}.}

\item{fixEff}{fixed effect to assign to the population. Used
by genomic selection models only.}

\item{p}{the p-value for the environmental covariate
used by GxE traits. If NULL, a value is
sampled at random.}

\item{inbred}{are both pop and testers fully inbred. They are only
fully inbred if created by \code{\link{newPop}} using inbred founders
or by the \code{\link{makeDH}} function}

\item{onlyPheno}{should only the phenotype be returned, see return}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}} or
a matrix if onlyPheno=TRUE
}
\description{
Calculates general combining ability from a set of testers and
returns these values as phenotypes for a population.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10, inbred=TRUE)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Set phenotype to average per
pop2 = setPhenoGCA(pop, pop, use="gv", inbred=TRUE, simParam=SP)

}
