% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frontend.R
\name{response_data}
\alias{response_data}
\title{Get query records as a data frame}
\usage{
response_data(query)
}
\arguments{
\item{query}{The query object to extract the data frame from.}
}
\value{
A data frame with the information requested in the query.
}
\description{
Obtain the data frame with the records from a successful query.
}
\examples{
library(ArctosR)

if (interactive()) {
  # Request to download all available data
  query <- get_records(
    scientific_name = "Canis lupus", guid_prefix = "MSB:Mamm",
    columns = list("guid", "parts", "partdetail")
  )

  # Grab the dataframe of records from the query
  df <- response_data(query)
}

}
