% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangePointTests.R
\name{Andrews.test}
\alias{Andrews.test}
\title{Andrews' Test for End-of-Sample Structural Change}
\usage{
Andrews.test(x, M, formula = NULL)
}
\arguments{
\item{x}{Data to test for change in mean (either a vector or
\code{data.frame})}

\item{M}{Numeric index of the location of the first potential change point}

\item{formula}{The regression formula, which will be passed to
\code{\link[stats]{lm}}}
}
\value{
A \code{htest}-class object containing the results of the test
}
\description{
Performs Andrews' test for end-of-sample structural change, as described in
\insertCite{andrews03}{CPAT}. This function works for both univariate and
multivariate data depending on the nature of \code{x} and whether
\code{formula} is specified. This function is thus an interface to
\code{\link{andrews_test}} and \code{\link{andrews_test_reg}}; see the
documentation of those functions for more details.
}
\examples{
Andrews.test(rnorm(1000), M = 900)
x <- rnorm(1000)
y <- 1 + 2 * x + rnorm(1000)
df <- data.frame(x, y)
Andrews.test(df, y ~ x, M = 900)
}
\references{
\insertAllCited{}
}
