% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbabilityFunctions.R
\name{sim_Zn}
\alias{sim_Zn}
\title{Rènyi-Type Statistic Simulation (Assuming Variance)}
\usage{
sim_Zn(size, kn, n = 500, gen_func = rnorm, args = NULL, sd = 1)
}
\arguments{
\item{size}{Number of realizations to simulate}

\item{kn}{A function returning a positive integer that is used in the
definition of the Rènyi-type statistic effectively setting the
bounds over which the maximum is taken}

\item{n}{The sample size for each realization}

\item{gen_func}{The function generating the random sample from which the
statistic is computed}

\item{args}{A list of arguments to be passed to \code{gen_func}}

\item{sd}{The square root of the second moment of the data}
}
\value{
A vector of simulated realizations of the Rènyi-type statistic
}
\description{
Simulates multiple realizations of the Rènyi-type statistic when the long-run
variance of the data is known.
}
\examples{
CPAT:::sim_Zn(100, kn = function(n) {floor(log(n))})
CPAT:::sim_Zn(100, kn = function(n) {floor(log(n))},
              gen_func = CPAT:::rchangepoint, args = list(changepoint = 250,
                                                          mean2 = 1))
}
