% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{sample.delta}
\alias{sample.delta}
\title{Function to sample from the posterior of the variance parameter}
\usage{
sample.delta(eta, ND, EV, Q, pars)
}
\arguments{
\item{eta}{samples of the smoothing parameter from the sample.eta function.}

\item{ND}{the rank of the precision matrix, the default value is n-3 for spatial data.}

\item{EV}{eigenvalues of the precision matrix spatial prior from the function make.M().}

\item{Q}{the data vector from the cross-product of observed data, Y, and eigenvalues from the M matrix, V.}

\item{pars}{a vector of the prior shape and rate parameters for the
inverse-gamma prior distribution of delta.}
}
\value{
N samples drawn from the posterior of \eqn{\pi(delta | eta, y)}.
}
\description{
This function samples from the log-posterior density of the variance parameter from the likelihood
}
\examples{
## Use the Meuse River dataset from the package 'gstat'

library(sp)
library(gstat)
data(meuse.all)
coordinates(meuse.all) <- ~ x + y
X <- scale(coordinates(meuse.all))
tmp <- make.M(X)

M <- tmp$M

Y <- scale(log(meuse.all$zinc))

ND <- nrow(X) - 3
M.list <- make.M(X) ##  Only Needs to return the eigenvalues and vectors
M <- M.list$M
EV <- M.list$M.eigen$values
V <- M.list$M.eigen$vectors
Q <- crossprod(Y, V)

f <- function(x) -x ## log-prior for exponential distribution for the smoothing parameter
## Draw 100 samples from the posterior of eta given the data y.

ETA <- sample.eta(100, ND, EV, Q, f, UL = 1000)
DELTA <- sample.delta(ETA, ND, EV, Q, pars = c(0.001, 0.001))
##  Old Slow Version of sample.nu()
## sample.delta<-function(eta,nd,ev,Q,pars)
## {
##   N<-length(eta)
##   f.beta<-function(x)
##   {
##     lambda<-1/(1+x*ev)
##     b<-tcrossprod(Q,diag(1-lambda))
##     beta<-0.5*tcrossprod(Q,b)+pars[2]
##     return(beta)
##   }
##   alpha<-pars[1]+nd*0.5
##   beta<-sapply(eta,f.beta)
##   delta<-1/rgamma(N,shape=alpha,rate=beta)
##   return(delta)
## }
}
