% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScalePreviousPlot.R
\name{ScalePreviousPlot}
\alias{ScalePreviousPlot}
\title{Return the scale of the previous plot}
\usage{
ScalePreviousPlot(x = NULL, y = NULL)
}
\arguments{
\item{x}{The position in x as relative position}

\item{y}{The position in y as relative position}
}
\value{
A list with xlim and ylim
}
\description{
Return a list with the limits of the previous plot, the center, the range, and the position of label on this axe.
}
\details{
ScalePreviousPlot returns the scale of the previous plot
}
\examples{
\dontrun{
par(xaxs="i", yaxs="i")
plot(x=1:100, y=sin(1:100), type="l", bty="n", xlim=c(1,200), xlab="x", ylab="y")
xlim= ScalePreviousPlot()$xlim[1:2]
ylim= ScalePreviousPlot()$ylim[1:2]
par(xaxs="r", yaxs="i")
plot(x=1:100, y=sin(1:100), type="l", bty="n", xlim=c(1,200), xlab="x", ylab="y")
xlim= ScalePreviousPlot()$xlim[1:2]
ylim= ScalePreviousPlot()$ylim[1:2]
# Here is an example of the use of the label output
plot(x=1:100, y=sin(1:100), type="l", bty="n", xlim=c(1,200), xlab="", ylab="")
text(x=ScalePreviousPlot()$xlim["label"], y=ScalePreviousPlot()$ylim["center"], 
  xpd=TRUE, "Legend for Y axes", pos=3, srt=90)
text(x=ScalePreviousPlot()$xlim["center"], y=ScalePreviousPlot()$ylim["label"], 
  xpd=TRUE, "Legend for X axes", pos=1)
Example to plot legend always in the same place
layout(1:2)
plot(x=1:100, y=sin(1:100), type="l", bty="n", xlim=c(1,200), xlab="", ylab="")
text(x=ScalePreviousPlot(x=0.95, y=0.05)$x, 
     y=ScalePreviousPlot(x=0.95, y=0.05)$y, 
     labels="A", cex=2)
plot(x=0:1, y=0:1, type="p", bty="n")
text(x=ScalePreviousPlot(x=0.95, y=0.05)$x, 
     y=ScalePreviousPlot(x=0.95, y=0.05)$y, 
     labels="B", cex=2)
}
}
\seealso{
Other plot and barplot functions: 
\code{\link{barplot_errbar}()},
\code{\link{plot_add}()},
\code{\link{plot_errbar}()},
\code{\link{show_name}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{plot and barplot functions}
