% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_mode.R
\name{llm_mutate_structured}
\alias{llm_mutate_structured}
\title{Data-frame mutate with structured output}
\usage{
llm_mutate_structured(
  .data,
  output,
  prompt = NULL,
  .messages = NULL,
  .config,
  .system_prompt = NULL,
  .before = NULL,
  .after = NULL,
  .schema = NULL,
  .fields = NULL,
  ...
)
}
\arguments{
\item{.data}{A data.frame / tibble.}

\item{output}{Unquoted name that becomes \strong{the new column} (generative) \emph{or}
\strong{the prefix} for embedding columns.}

\item{prompt}{Optional glue template string for a single user turn; reference
any columns in \code{.data} (e.g. \code{"{id}. {question}\\nContext: {context}"}).
Ignored if \code{.messages} is supplied.}

\item{.messages}{Optional \strong{named} character vector of glue templates to build
a multi-turn message, using roles in \code{c("system","user","assistant","file")}.
Values are glue templates evaluated per-row; all can reference multiple columns.
For multimodal, use role \code{"file"} with a column containing a path template.}

\item{.config}{An \link{llm_config} object (generative or embedding).}

\item{.system_prompt}{Optional system message sent with every request when
\code{.messages} does not include a \code{system} entry.}

\item{.before, .after}{Standard \link[dplyr:relocate]{dplyr::relocate} helpers controlling where the
generated column(s) are placed.}

\item{.schema}{Optional JSON Schema list; if \code{NULL}, only JSON object is enforced.}

\item{.fields}{Optional fields to hoist (supports nested paths).}

\item{...}{Passed to the underlying calls: \code{\link[=call_llm_broadcast]{call_llm_broadcast()}} in
generative mode, \code{\link[=get_batched_embeddings]{get_batched_embeddings()}} in embedding mode.}
}
\description{
Drop-in schema-first variant of \code{\link[=llm_mutate]{llm_mutate()}}. Produces parsed columns.
}
