% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cbh_bpoint.R
\name{get_plots_cbh_bp}
\alias{get_plots_cbh_bp}
\title{Plot of the Crown Base Height (CBH) based on the breaking point method}
\usage{
get_plots_cbh_bp(LAD_profiles, cummulative_LAD, min_height = 1.5)
}
\arguments{
\item{LAD_profiles}{original tree Leaf Area Density (LAD) profile (output of [lad.profile()] function from leafR package).
An object of the class text.}

\item{cummulative_LAD}{tree metrics derived from using breaking points on cummulative LAD (output of [get_cum_break()] function).
An object of the class text.}

\item{min_height}{Numeric value for the actual minimum base height (in meters).}
}
\value{
A plot of the Crown Base Height (CBH) based on the breaking point method and Leaf Area Density (LAD) percentage of the canopy layer.
}
\description{
This function plots the crown base height (CBH) based on breaking point over the cummulative LAD values and gives the LAD percentage
of the canopy layer
}
\examples{
library(ggplot2)
library(dplyr)

# LAD profiles derived from normalized ALS data after applying [lad.profile()] function
LAD_profiles <- read.table(system.file("extdata", "LAD_profiles.txt", package = "LadderFuelsR"),
header = TRUE)
LAD_profiles$treeID <- factor(LAD_profiles$treeID)

# Before running this example, make sure to run get_cum_break().
if (interactive()) {
cummulative_LAD <- get_cum_break()
LadderFuelsR::cummulative_LAD$treeID <- factor(LadderFuelsR::cummulative_LAD$treeID)

# Generate cumulative LAD plots
plots_cbh_bp <- get_plots_cbh_bp(LAD_profiles, cummulative_LAD,min_height = 1.5)
}
}
\seealso{
\code{\link{get_cum_break}}
}
\author{
Olga Viedma, Carlos Silva, JM Moreno and A.T. Hudak
}
