% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additionalFunctions.R
\name{searchIsotopesmsbatch}
\alias{searchIsotopesmsbatch}
\title{Targeted isotopes search for msbatch}
\usage{
searchIsotopesmsbatch(
  msbatch,
  label,
  adductsTable = LipidMS::adductsTable,
  ppm = 10,
  coelCutoff = 0.7
)
}
\arguments{
\item{msbatch}{annotated msbatch.}

\item{label}{isotope employed for the experiment. It can be "13C" or "D".}

\item{adductsTable}{adducts table employed for lipids annotation.}

\item{ppm}{mass error tolerance.}

\item{coelCutoff}{coelution score threshold between isotopes. By default, 0.7.}
}
\value{
List with the isotopes for each compound in the results data frame.
}
\description{
This function uses annotation results of deisotoped data to search
for isotopes in raw data.
}
\examples{
\dontrun{
msbatch <- batchProcessing(metadata = "metadata.csv", polarity = "positive")
msbatch <- alignmsbatch(msbatch)
msbatch <- groupmsbatch(msbatch)
msbatch <- annotatemsbatch(msbatch)
searchIsotopesmsbatch(msbatch, label = "13C")
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
