% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{preprocessing}
\alias{preprocessing}
\title{Preprocessing Data Matrix}
\usage{
preprocessing(
  df,
  formula,
  task = "regression",
  num_vars = NULL,
  cat_vars = NULL,
  norm_num_vars = "all",
  encode_cat_vars = "all",
  y_levels = NULL
)
}
\arguments{
\item{df}{Input DataFrame. Either a data.frame or tibble.}

\item{formula}{Modelling Formula. A string of characters or formula.}

\item{task}{Modelling Task. Either "regression" or "classification".}

\item{num_vars}{Optional vector of names of the numerical features.}

\item{cat_vars}{Optional vector of names of the categorical features.}

\item{norm_num_vars}{Normalize numeric features as z-scores. Either vector of
names of numerical features to be normalized or "all" (default).}

\item{encode_cat_vars}{One Hot Encode Categorical Features. Either vector of
names of categorical features to be encoded or "all" (default).}

\item{y_levels}{Optional ordered vector with names of the target variable levels (Classification task only).}
}
\value{
The object returned by the preprocessing function encapsulates a dataset specifically prepared
for ML analysis. This object contains the preprocessed data—where variables have been selected, standardized,
encoded, and formatted according to the requirements of the chosen modeling task (regression or classification)
—as well as a recipes::recipe object that documents all preprocessing steps applied. By automating essential
transformations such as normalization, one-hot encoding of categorical variables, and the handling of
missing values, the function ensures the data is optimally structured for input into machine learning
algorithms. This comprehensive preprocessing not only exposes the underlying structure of the data and
reduces the risk of errors, but also provides a robust foundation for subsequent modeling, validation,
and interpretation within the machine learning workflow (Kuhn & Johnson, 2019).
}
\description{
The \strong{preprocessing()} function streamlines data preparation for regression and classification tasks by
integrating variable selection, type conversion, normalization, and categorical encoding into a single
workflow. It takes a data frame and a formula, applies user-specified transformations to numeric and
categorical variables using the recipes package, and ensures the outcome variable is properly formatted.
The function returns an AnalysisObject containing both the processed data and the transformation pipeline,
supporting reproducible and efficient modeling (Kuhn & Wickham, 2020).
}
\examples{
# Example 1: Dataset with preformatted categorical variables
# In this case, internal options for variable types are not needed since categorical features
# are already formatted as factors.

library(MLwrap)

data(sim_data) # sim_data is a simulated dataset with psychological variables

wrap_object <- preprocessing(
          df = sim_data,
          formula = psych_well ~ depression + emot_intel + resilience + life_sat + gender,
          task = "regression"
         )

# Example 2: Dataset where neither the outcome nor the categorical features are formatted as factors
# and all categorical variables are specified to be formatted as factors

wrap_object <- preprocessing(
           df = sim_data,
           formula = psych_well_bin ~ gender + depression + age + life_sat,
           task = "classification",
           cat_vars = c("gender")
         )
}
\references{
Kuhn, M., & Johnson, K. (2019). \emph{Feature Engineering and Selection: A Practical Approach
for Predictive Models (1st ed.)}. Chapman and Hall/CRC. https://doi.org/10.1201/9781315108230

Kuhn, M., & Wickham, H. (2020). \emph{Tidymodels: a collection of packages for modeling and machine
learning using tidyverse principles}. https://www.tidymodels.org.
}
