# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

vecminInd <- function(x) {
    .Call('_MSEtool_vecminInd', PACKAGE = 'MSEtool', x)
}

LinInterp_cpp <- function(x, y, xlev) {
    .Call('_MSEtool_LinInterp_cpp', PACKAGE = 'MSEtool', x, y, xlev)
}

#'  Internal function to calculate MSY Reference Points
#'
#' @param logF log fishing mortality
#' @param M_at_Age Vector of M-at-age
#' @param Wt_at_Age Vector of stock weight-at-age
#' @param Mat_at_Age Vector of maturity-at-age
#' @param Fec_at_Age Vector of mature weight-at-age
#' @param V_at_Age Vector of selectivity-at-age
#' @param Wt_at_Age_C Vector of fishery weight-at-age
#' @param maxage Maximum age
#' @param relRfun Optional. A function used to calculate reference points if `SRrelc =3` 
#' @param SRRpars Optional. A named list of arguments for `SRRfun`
#' @param R0x R0 for this simulation. Set = 1 if SRrelx = 4 for per-recruit calculations
#' @param SRrelx SRR type for this simulation. Use 4 for per-recruit calculations, i.e. constant recruitment.
#' @param hx numeric. Steepness value for this simulation. Not used if SRrelx = 4.
#' @param SSBpR numeric. Unfished spawners per recruit for this simulation. Not used if SRrelx = 4.
#' @param opt Option. 1 = return -Yield, 2= return all MSY calcs
#' @param plusgroup Integer. Default = 0 = no plus-group. Use 1 to include a plus-group
#' @param spawn_time_frac Numeric. Fraction of the year when spawning occurs. Default = 0. 
#' @return See `opt`
MSYCalcs <- function(logF, M_at_Age, Wt_at_Age, Mat_at_Age, Fec_at_Age, V_at_Age, Wt_at_Age_C, maxage, relRfun, SRRpars, R0x = 1, SRrelx = 3L, hx = 1, SSBpR = 0, opt = 1L, plusgroup = 1L, spawn_time_frac = 0) {
    .Call('_MSEtool_MSYCalcs', PACKAGE = 'MSEtool', logF, M_at_Age, Wt_at_Age, Mat_at_Age, Fec_at_Age, V_at_Age, Wt_at_Age_C, maxage, relRfun, SRRpars, R0x, SRrelx, hx, SSBpR, opt, plusgroup, spawn_time_frac)
}

Ref_int_cpp <- function(F_search, M_at_Age, Wt_at_Age, Mat_at_Age, Fec_at_Age, V_at_Age, Wt_at_Age_C, relRfun, SRRpars, maxage, plusgroup = 1L, spawn_time_frac = 0) {
    .Call('_MSEtool_Ref_int_cpp', PACKAGE = 'MSEtool', F_search, M_at_Age, Wt_at_Age, Mat_at_Age, Fec_at_Age, V_at_Age, Wt_at_Age_C, relRfun, SRRpars, maxage, plusgroup, spawn_time_frac)
}

calcVatAge <- function(len_at_age, len_aa_sd, sel_at_length, n_age, nyears, proyears, CAL_binsmid) {
    .Call('_MSEtool_calcVatAge', PACKAGE = 'MSEtool', len_at_age, len_aa_sd, sel_at_length, n_age, nyears, proyears, CAL_binsmid)
}

combine <- function(list) {
    .Call('_MSEtool_combine', PACKAGE = 'MSEtool', list)
}

get_freq <- function(x, width, origin = 0, outlen = 0L) {
    .Call('_MSEtool_get_freq', PACKAGE = 'MSEtool', x, width, origin, outlen)
}

get_freq2 <- function(x, CAL_bins, outlen = 0L) {
    .Call('_MSEtool_get_freq2', PACKAGE = 'MSEtool', x, CAL_bins, outlen)
}

rnormSelect2 <- function(N, mi, ma) {
    .Call('_MSEtool_rnormSelect2', PACKAGE = 'MSEtool', N, mi, ma)
}

tdnorm <- function(x, mi, ma) {
    .Call('_MSEtool_tdnorm', PACKAGE = 'MSEtool', x, mi, ma)
}

genSizeComp <- function(VulnN, CAL_binsmid, CAL_bins, selCurve, CAL_ESS, CAL_nsamp, Linfs, Ks, t0s, LenCV, truncSD) {
    .Call('_MSEtool_genSizeComp', PACKAGE = 'MSEtool', VulnN, CAL_binsmid, CAL_bins, selCurve, CAL_ESS, CAL_nsamp, Linfs, Ks, t0s, LenCV, truncSD)
}

genSizeComp2 <- function(VulnN, CAL_binsmid, CAL_bins, selCurve, CAL_ESS, CAL_nsamp, Linfs, Ks, t0s, LenCV, truncSD) {
    .Call('_MSEtool_genSizeComp2', PACKAGE = 'MSEtool', VulnN, CAL_binsmid, CAL_bins, selCurve, CAL_ESS, CAL_nsamp, Linfs, Ks, t0s, LenCV, truncSD)
}

grav <- function(log_visc, log_grav, fracs, nareas) {
    .Call('_MSEtool_grav', PACKAGE = 'MSEtool', log_visc, log_grav, fracs, nareas)
}

#' Rcpp version of the Optimization function that returns the squared difference between user
#' specified and calculated movement parameters. 
#'
#' The user specifies the probability of staying in the same area and spatial
#' heterogeneity (both in the unfished state). This function returns the
#' squared difference between these values and those produced by the three
#' logit movement model.
#'
#' This is paired with getmov to find the correct movement model. 
#' 
#' @param par Three parameters in the logit space that control the four
#' probabilities of moving between 2 areas
#' @param prb User specified probability that individuals in area 1 remain in
#' that area (unfished conditions)
#' @param frac User specified fraction of individuals found in area 1 (unfished
#' conditions)
#' 
#' @author T. Carruthers with an amateur attempt at converting to Rcpp by A. Hordyk (but it works!)
#' @useDynLib MSEtool
#' @export
movfit_Rcpp <- function(par, prb, frac) {
    .Call('_MSEtool_movfit_Rcpp', PACKAGE = 'MSEtool', par, prb, frac)
}

#' Aging and Mortality for one time-step
#'
#' Project population forward one time-step given current numbers-at-age and total mortality
#'
#' @param nareas The number of spatial areas
#' @param maxage The maximum age
#' @param Ncurr A numeric matrix (maxage+1, nareas) with current numbers-at-age in each area
#' @param Zcurr A numeric matrix (maxage+1, nareas) with total mortality-at-age in each area
#'
#' @author A. Hordyk
#'
#' @keywords internal
popdynOneTScpp <- function(nareas, maxage, Ncurr, Zcurr, plusgroup = 1L) {
    .Call('_MSEtool_popdynOneTScpp', PACKAGE = 'MSEtool', nareas, maxage, Ncurr, Zcurr, plusgroup)
}

#' Apply the movement model to the stock for one time-step
#'
#'
#'
#' @param nareas The number of spatial areas
#' @param maxage The maximum age
#' @param mov Numeric matrix (nareas by nareas) with the movement matrix
#' @param Number A numeric matrix (maxage+1, nareas) with current numbers-at-age in each area
#'
#' @author A. Hordyk
#'
#' @export
movestockCPP <- function(nareas, maxage, mov, Number) {
    .Call('_MSEtool_movestockCPP', PACKAGE = 'MSEtool', nareas, maxage, mov, Number)
}

#' Population dynamics model in CPP
#'
#' Project population forward pyears given current numbers-at-age and total mortality, etc
#' for the future years
#'
#' @param nareas The number of spatial areas
#' @param maxage The maximum age
#' @param Ncurr A numeric matrix (maxage+1, nareas) with current numbers-at-age in each area
#' @param pyears The number of years to project the population forward
#' @param M_age Numeric matrix (maxage+1, pyears) with natural mortality by age and year
#' @param Asize_c Numeric vector (length nareas) with size of each area
#' @param MatAge Numeric vector with proportion mature by age
#' @param WtAge Numeric matrix (maxage+1, pyears) with weight by age and year
#' @param FecAge Numeric matrix (maxage+1, pyears) with mature female weight by age and year
#' @param Vuln Numeric matrix (maxage+1, pyears) with vulnerability by age and year
#' @param Retc Numeric matrix (maxage+1, pyears) with retention by age and year
#' @param Prec Numeric vector (pyears) with recruitment error
#' @param movc Numeric array (nareas by nareas) with the movement matrix
#' @param SRrelc Integer indicating the stock-recruitment relationship to use (1 for Beverton-Holt, 2 for Ricker)
#' @param Effind Numeric vector (length pyears) with the fishing effort by year
#' @param Spat_targc Integer. Spatial targeting
#' @param hc Numeric. Steepness of stock-recruit relationship
#' @param R0c Numeric vector of length nareas with unfished recruitment by area
#' @param SSBpRc Numeric vector of length nareas with unfished spawning per recruit by area
#' @param aRc Numeric. Ricker SRR a value by area
#' @param bRc Numeric. Ricker SRR b value by area
#' @param Qc Numeric. Catchability coefficient
#' @param Fapic Numeric. Apical F value
#' @param maxF A numeric value specifying the maximum fishing mortality for any single age class
#' @param MPA Spatial closure by year and area
#' @param control Integer. 1 to use q and effort to calculate F, 2 to use Fapic (apical F) and
#' vulnerability to calculate F.
#' @param SRRfun Optional. A stock-recruit function used if `SRrelc =3` 
#' @param SRRpars Optional. A named list of arguments for `SRRfun`
#' @param plusgroup Integer. Include a plus-group (1) or not (0)?
#' @param spawn_time_frac Numeric. Fraction of the year when spawning occurs. Default = 0.
#'
#' @author A. Hordyk
#' @keywords internal
popdynCPP <- function(nareas, maxage, Ncurr, pyears, M_age, Asize_c, MatAge, WtAge, FecAge, Vuln, Retc, Prec, movc, SRrelc, Effind, Spat_targc, hc, R0c, SSBpRc, aRc, bRc, Qc, Fapic, maxF, MPA, control, SSB0c, SRRfun, SRRpars, plusgroup = 0L, spawn_time_frac = 0) {
    .Call('_MSEtool_popdynCPP', PACKAGE = 'MSEtool', nareas, maxage, Ncurr, pyears, M_age, Asize_c, MatAge, WtAge, FecAge, Vuln, Retc, Prec, movc, SRrelc, Effind, Spat_targc, hc, R0c, SSBpRc, aRc, bRc, Qc, Fapic, maxF, MPA, control, SSB0c, SRRfun, SRRpars, plusgroup, spawn_time_frac)
}

