% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionQueries.R
\name{getPredictionModelDesigns}
\alias{getPredictionModelDesigns}
\title{Extract the model designs and aggregate performances for the prediction results}
\usage{
getPredictionModelDesigns(
  connectionHandler,
  schema,
  plpTablePrefix = "plp_",
  cgTablePrefix = "cg_",
  targetIds = NULL,
  outcomeIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}
}
\value{
Returns a data.frame with the columns:
\itemize{ 
 \item{modelDesignId a unique identifier in the database for the model design}
 \item{modelType the type of classifier or surival model}
 \item{developmentTargetId a unique identifier for the development target ID}
 \item{developmentTargetName the name of the development target cohort}
 \item{developmentTargetJson the json of the target cohort}
 \item{developmentOutcomeId a unique identifier for the development outcome ID}
 \item{developmentOutcomeName the name of the development outcome cohort}
 \item{timeAtRisk the time at risk string}
 \item{developmentOutcomeJson the json of the outcome cohort}
 \item{covariateSettingsJson the covariate settings json}
 \item{populationSettingsJson the population settings json}
 \item{tidyCovariatesSettingsJson the tidy covariate settings json}
 \item{plpDataSettingsJson the plp data extraction settings json}
 \item{featureEngineeringSettingsJson the feature engineering settings json}
 \item{splitSettingsJson the split settings json}
 \item{sampleSettingsJson the sample settings json}
 \item{minAuroc the min AUROC value of models developed using the model design across databases}
 \item{meanAuroc the mean AUROC value of models developed using the model design across databases}
 \item{maxAuroc the max AUROC value of models developed using the model design across databases}
 \item{noDiagnosticDatabases the number of databases where the model design diagnostics were generated}
 \item{noDevelopmentDatabases the number of databases where the model design was used to develop models}
 \item{noValidationDatabases the number of databases where the models developed using the model design was externally validated}
}
}
\description{
This function extracts the model design settings and min/max/mean AUROC values of the models developed
using the model design across databases
}
\details{
Specify the connectionHandler, the resultDatabaseSettings and (optionally) any targetIds or outcomeIds to restrict model designs to
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

modDesign <- getPredictionModelDesigns(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Prediction: 
\code{\link{getPredictionCohorts}()},
\code{\link{getPredictionDiagnosticTable}()},
\code{\link{getPredictionDiagnostics}()},
\code{\link{getPredictionHyperParamSearch}()},
\code{\link{getPredictionIntercept}()},
\code{\link{getPredictionPerformanceTable}()},
\code{\link{getPredictionPerformances}()},
\code{\link{getPredictionTopPredictors}()}
}
\concept{Prediction}
