% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLogistic.R
\name{fitLogistic}
\alias{fitLogistic}
\title{Fit logistic regression model}
\usage{
fitLogistic(formula, placebo, data, alternative, scale, ...)
}
\arguments{
\item{formula}{An object of class \code{formula}. Must include \code{arm}
and endpoint in \code{data}. Covariates can be adjusted.}

\item{placebo}{Character. String indicating the placebo in \code{data$arm}.}

\item{data}{Data frame. Usually it is a locked data set.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"greater"} or \code{"less"},
i.e., one-sided test is enforced. No default value.
\code{"greater"} means superiority of treatment over placebo is established
by an odds ratio greater than 1.}

\item{scale}{character. The type of estimate in the output. Must be one
of \code{"coefficient"}, \code{"log odds ratio"}, \code{"odds ratio"}, \code{"risk ratio"},
or \code{"risk difference"}. No default value.}

\item{...}{Subset conditions compatible with \code{dplyr::filter}.
\code{glm} will be fitted on this subset only. This argument can be useful
to create a subset of data for analysis when a trial consists of more
than two arms. By default, it is not specified,
all data will be used to fit the model. More than one condition can be
specified in \code{...}, e.g.,
\code{fitLogistic(remission ~ arm, 'pbo', data, 'greater', 'odds ratio', arm \%in\% c('pbo', 'low dose'), cfb > 0.5)},
which is equivalent to:
\code{fitLogistic(remission ~ arm, 'pbo', data, 'greater', 'odds ratio', arm \%in\% c('pbo', 'low dose') & cfb > 0.5)}.
Note that if more than one treatment arm are present in the data after
applying filter in \code{...}, models are fitted for placebo verse
each of the treatment arms.}
}
\value{
a data frame with columns:
\describe{
\item{\code{arm}}{name of the treatment arm. }
\item{\code{placebo}}{name of the placebo arm. }
\item{\code{estimate}}{estimate depending on \code{scale}. }
\item{\code{p}}{one-sided p-value for log odds ratio (treated vs placebo). }
\item{\code{info}}{sample size used in model with \code{NA} being removed. }
\item{\code{z}}{z statistics of log odds ratio (treated vs placebo). }
}
}
\description{
Fit logistic regression model on an binary endpoint.

Refer to \href{https://zhangh12.github.io/TrialSimulator/articles/wrappers.html}{this vignette}
for more information and examples.
}
