% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbt.complexity.R
\name{gbt.complexity}
\alias{gbt.complexity}
\title{Return complexity of model in terms of hyperparameters.}
\usage{
gbt.complexity(model, type)
}
\arguments{
\item{model}{object or pointer to object of class \code{ENSEMBLE}}

\item{type}{currently supports "xgboost" or "lightgbm"}
}
\value{
\code{list} with \code{type} hyperparameters.
}
\description{
\code{gbt.complexity} creates a list of hyperparameters from a model
}
\details{
Returns the complexity of \code{model} in terms of hyperparameters associated
to model \code{type}.
}
\examples{
\donttest{
set.seed(123)
library(agtboost)
n <- 10000
xtr <- as.matrix(runif(n, 0, 4))
ytr <- rnorm(n, xtr, 1)
xte <- as.matrix(runif(n, 0, 4))
yte <- rnorm(n, xte, 1)
model <- gbt.train(ytr, xtr, learning_rate = 0.1)
gbt.complexity(model, type="xgboost")
gbt.complexity(model, type="lightgbm")
## See demo(topic="gbt-complexity", package="agtboost")
}

}
