% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldvmm.getpar.R
\name{aldvmm.getpar}
\alias{aldvmm.getpar}
\title{Extracting Parameters from Parameter Vector into Nested List.}
\usage{
aldvmm.getpar(par, lcoef, lcmp, lcpar, ncmp)
}
\arguments{
\item{par}{a named numeric vector of parameter values.}

\item{lcoef}{a character vector of length 2 with labels of objects including
regression coefficients of component distributions (default \code{"beta"})
and coefficients of probabilities of component membership (default
\code{"delta"}).}

\item{lcmp}{a character value representing a stub (default \code{"Comp"})
for labeling objects including regression coefficients in different
components (e.g. "Comp1", "Comp2", ...). This label is also used in
summary tables returned by
\ifelse{html}{\code{\link[aldvmm]{summary.aldvmm}}}{\code{summary.aldvmm()}}.}

\item{lcpar}{a character vector with the labels of objects including
constant parameters of component distributions (e.g. the standard
deviation of the normal distribution). The length of \code{'lcpar'}
depends on the distribution supplied to \code{'dist'}.}

\item{ncmp}{a numeric value of the number of components that are mixed. The
default value is 2. A value of 1 represents a tobit model with a gap
between 1 and the maximum value in \code{'psi'}.}
}
\value{
a named nested list with parameter vectors for \code{"beta"},
  \code{"delta"} and \code{"lnsigma"} within all \code{1:K} components. The
  names of the list correspond to the labels in \code{'lcoef'},
  \code{'lcpar'} and \code{'lcmp'}.
}
\description{
\code{aldvmm.getpar()} extracts parameters from parameter vectors into nested
lists.
}
\details{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.getpar}}}{\code{aldvmm.getpar()}}
identifies parameters that belong to coefficients of component distributions
(label \code{"beta"}), coefficients of the multinomial logit model of
probabilities of component membership (label \code{"delta"}), constant
parameters of component distributions (label \code{"lnsigma"} for
\code{dist=="normal"}), and \code{1:K} components (labels "Comp1" ...
"CompK")) based on parameter names generated by
\ifelse{html}{\code{\link[aldvmm]{aldvmm.getnames}}}{\code{aldvmm.getnames()}}.
}
