% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{lapl_aprx2}
\alias{lapl_aprx2}
\title{Laplace approximation of posterior to normal}
\usage{
lapl_aprx2(y, x, family = "binomial", ...)
}
\arguments{
\item{y}{the binary dependent variable y}

\item{x}{the matrix of independent variables.}

\item{family}{a parameter to be passed \code{glm()}, defaults to the logit model}

\item{...}{additional parameters to be passed to \code{glm()}}
}
\value{
val A list of mode variance-covariance matrix, and scale factor for
proposal draws from the multivariate normal distribution.
}
\description{
\code{lapl_aprx2} is a more flexible alternative to \code{lapl_aprx}. This creates
\code{glm} objects from which joint asymptotic distributions can be computed.
}
\examples{
y = indicat(faithful$waiting,mean(faithful$waiting)) 
x = scale(cbind(faithful$eruptions,faithful$eruptions^2))
(gg<- lapl_aprx2(y,x)); coef(gg); vcov(gg)

}
