% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_string_operation.R
\name{seq_remove_pattern}
\alias{seq_remove_pattern}
\title{Remove matched patterns in sequences}
\usage{
seq_remove_pattern(x, pattern)
}
\arguments{
\item{x}{a DNA, RNA or AA vector.}

\item{pattern}{a DNA, RNA or AA vectors (but same as \code{x})
or a character vector of regular expressions, or a list.
See section Patterns.}
}
\value{
A vector of same class as \code{x}.
}
\description{
Remove matched patterns in sequences
}
\section{Patterns}{

It is important to understand how patterns are treated in \pkg{bioseq}.

Patterns are recycled along the sequences (usually the \code{x} argument).
This means that if a pattern (vector or list) is of length > 1, it will be
replicated until it is the same length as \code{x}.
The reverse is not true and a vector of patterns longer than
a vector of sequences will raise a warning.

Patterns can be DNA, RNA or AA vectors
(but they must be from the same class as
the sequences they are matched against).
If patterns are DNA, RNA or AA vectors,
they are disambiguated prior to matching.
For example pattern dna("ARG") will match AAG or AGG.

Alternatively, patterns can be a simple character vector
containing regular expressions.

Vectors of patterns (DNA, RNA, AA or regex) can also be provided in a list.
In that case, each vector of the list will be collapsed prior matching,
which means that each vector element will be used as an alternative pattern.
For example pattern list(c("AAA", "CCC"), "GG")
will match AAA or CCC in the first sequence,
GG in the second sequence, AAA or CCC in the third,
and so on following the recycling rule.

 @section Fuzzy matching:
When \code{max_error} is greater than zero, the function perform
fuzzy matching. Fuzzy matching does not support regular expression.
}

\examples{

x <- dna("ACGTTAGTGTAGCCGT", "CTCGAAATGA")
seq_remove_pattern(x, dna("AAA"))
seq_remove_pattern(x, "^A.{2}T")

}
\seealso{
\code{\link[stringr]{str_remove}} from \pkg{stringr}
for the underlying implementation.

Other string operations: 
\code{\link{seq-replace}},
\code{\link{seq_combine}()},
\code{\link{seq_count_pattern}()},
\code{\link{seq_crop_pattern}()},
\code{\link{seq_crop_position}()},
\code{\link{seq_detect_pattern}()},
\code{\link{seq_extract_pattern}()},
\code{\link{seq_extract_position}()},
\code{\link{seq_remove_position}()},
\code{\link{seq_replace_position}()},
\code{\link{seq_split_kmer}()},
\code{\link{seq_split_pattern}()}
}
\concept{string operations}
