% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_distribution.R
\name{beta_distribution}
\alias{beta_distribution}
\alias{beta_pdf}
\alias{beta_lpdf}
\alias{beta_cdf}
\alias{beta_lcdf}
\alias{beta_quantile}
\title{Beta Distribution Functions}
\usage{
beta_pdf(x, alpha, beta)

beta_lpdf(x, alpha, beta)

beta_cdf(x, alpha, beta)

beta_lcdf(x, alpha, beta)

beta_quantile(p, alpha, beta)
}
\arguments{
\item{x}{quantile (0 <= x <= 1)}

\item{alpha}{shape parameter (alpha > 0)}

\item{beta}{shape parameter (beta > 0)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Beta distribution.
}
\examples{
# Beta distribution with shape parameters alpha = 2, beta = 5
beta_pdf(0.5, 2, 5)
beta_lpdf(0.5, 2, 5)
beta_cdf(0.5, 2, 5)
beta_lcdf(0.5, 2, 5)
beta_quantile(0.5, 2, 5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/beta_dist.html}{Boost Documentation} for more details on the mathematical background.
}
