% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trigonometric.R
\name{gen_curvycylinder}
\alias{gen_curvycylinder}
\title{Generate Curvy Cylinder}
\usage{
gen_curvycylinder(n = 500, p = 4, h = 10, noise_fun = gen_wavydims2, ...)
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{h}{A numeric value (default: 10) representing the height of the cylinder.}

\item{noise_fun}{A function specifying which noise generation function to use for the additional dimensions. Default is \code{gen_wavydims2}. Other options include \code{gen_noisedims}, \code{gen_wavydims2}, and \code{gen_wavydims3}.}

\item{...}{Additional arguments passed to the selected \code{noise_fun} (e.g., \code{m}, \code{s}, \code{theta}, \code{x1_vec}, \code{data}).}
}
\value{
A data containing a curvy cylinder.
}
\description{
This function generates a dataset representing a structure with a curvy cylinder.
}
\examples{
set.seed(20240412)
curvycylinder <- gen_curvycylinder(n = 500, p = 4, h = 10)
}
