% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_cmip6_data.R
\name{extract_cmip6_data}
\alias{extract_cmip6_data}
\title{Unpacks and formats downloaded CMIP6 data}
\usage{
extract_cmip6_data(
  stations,
  variable = c("Tmin", "Tmax"),
  download_path = "cmip6_downloaded",
  keep_downloaded = TRUE
)
}
\arguments{
\item{stations}{data.frame with the locations of interest, for which the
CMIP6 data should be extracted. Needs to contain the columns 'longitude',
'latitude' and 'station_name'.}

\item{variable}{character, decides which variables from the downloaded files
get read. Currently, valid options are "Tmin", "Tmax" and "Prec". The value
is usually the same as in download_cmip6_ecmwfr function.}

\item{download_path}{character, sets the path for the download of the CMIP6
file. If not already present, then a new folder will be created. The path is
relative to working directory.}

\item{keep_downloaded}{Boolean, by default set to TRUE. If TRUE, the
function will not delete the downloaded .nc files. This makes sense when the
user may want to use the climate change data for other locations.}
}
\value{
named list of data.frames. Element names follow the syntax
'SSP'_'GCM', where SSP is the shared socioeconomic pathway and GCM is the
global climate model that generated the weather data. The data.frames contain
the extracted values for the requested locations.
}
\description{
Opens the downloaded .zip files and returns the CMIP6 climate projections
for specified locations .
}
\examples{
\dontrun{
scenario<-c("ssp126", "ssp245", "ssp370", "ssp585")

download_cmip6_ecmwfr(scenario,
                         key = 'your-key-here'
                         user = 'your-user-name-here',
                         area =  c(52, -7, 33, 8) )


station <- data.frame(
    station_name = c('Zaragoza', 'Klein-Altendorf', 'Sfax', 'Cieza',
        'Meknes', 'Santomera'),
    longitude = c(-0.88,  6.99, 10.75, -1.41, -5.54, -1.05),
    latitude = c(41.65, 50.61, 34.75, 38.24, 33.88, 38.06))

extracted <- extract_cmip6_data(
    stations = station)
    
scenario <- gen_rel_change_scenario(
    extracted, years_local_weather = c(1992, 2021))

}


}
\author{
Lars Caspersen
}
