% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf2txtAI.R
\name{process_large_pdf}
\alias{process_large_pdf}
\title{Process Large PDF Documents with Google Gemini AI}
\usage{
process_large_pdf(
  pdf_path,
  api_key,
  pages_per_chunk = 4,
  model = c("1.5-flash", "2.0-flash", "2.5-flash")
)
}
\arguments{
\item{pdf_path}{Character. Path to the PDF file to be processed.}

\item{api_key}{Character. Google Gemini API key.}

\item{pages_per_chunk}{Integer. Number of pages to include in each chunk. Default is 4.
Lower values may help with very dense documents or API rate limits.}

\item{model}{Character. The Gemini model version to use. Options are:
"1.5-flash", "2.0-flash", "2.5-flash". Default is "2.0-flash".}
}
\value{
List of character vectors, one element per chunk, containing the extracted
and formatted text in markdown format. Returns NULL if processing fails.
}
\description{
Split a large PDF into chunks and process each chunk with Google Gemini AI to extract
and format text content. Particularly useful for PDFs that exceed the token limit
of a single API request.
}
\details{
The function performs the following steps:
\enumerate{
\item Validates input parameters and PDF file
\item Splits the PDF into chunks based on \code{pages_per_chunk}
\item Processes each chunk sequentially with Gemini AI
\item Extracts text while:
\itemize{
\item Removing repeated headers
\item Maintaining hierarchical structure
\item Preserving reference numbers in bracket notation
\item Formatting output as markdown
\item Handling sections that span multiple chunks
}
\item Returns a list of extracted text, one element per chunk
}

The function includes comprehensive error handling for:
\itemize{
\item Invalid or missing PDF files
\item Missing or invalid API keys
\item PDF processing errors
\item Gemini AI service errors
\item File system operations
}

Rate limiting: The function includes a 1-second delay between chunks to respect
API rate limits.
}
\note{
\itemize{
\item Requires \code{pdftools} package for PDF manipulation
\item Uses temporary files that are automatically cleaned up
\item Progress messages are printed for each chunk
\item All warnings are captured and reported
}
}
\examples{
\dontrun{
# Process a large PDF with default settings
result <- process_large_pdf(
  pdf_path = "large_document.pdf",
  api_key = Sys.getenv("GEMINI_API_KEY")
)

# Process with smaller chunks and specific model
result <- process_large_pdf(
  pdf_path = "very_large_document.pdf",
  api_key = Sys.getenv("GEMINI_API_KEY"),
  pages_per_chunk = 3,
  model = "2.5-flash"
)

# Combine all chunks into single text
if (!is.null(result)) {
  full_text <- paste(unlist(result), collapse = "\n\n")
}
}

}
\seealso{
\code{\link{gemini_content_ai}} for the underlying AI processing function
}
