% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{matViz}
\alias{matViz}
\title{Visualize a matrix}
\usage{
matViz(
  x,
  color1 = "white",
  color2 = "#500000",
  grid_color = "black",
  incl_val = FALSE,
  prec = 2,
  font_size = 3,
  font_color1 = "black",
  font_color2 = "white",
  font_thres = mean(x)
)
}
\arguments{
\item{x}{matrix; matrix to be visualized}

\item{color1}{color; color for low entries. \code{"white"} by default}

\item{color2}{color; color for high entries. \code{"#500000"} by default}

\item{grid_color}{color; color of grid lines. \code{"black"} by default}

\item{incl_val}{logical; if \code{TRUE}, the value for each entry will be
displayed. \code{FALSE} by default}

\item{prec}{positive integer; number of decimal places to round entries to if
\code{incl_val} is \code{TRUE}. \code{2} by default}

\item{font_size}{positive numeric; size of font if \code{incl_val} is \code{TRUE}. \code{3}
by default}

\item{font_color1}{color; color of font for low entries if \code{incl_val} is
\code{TRUE}. \code{"black"} by default}

\item{font_color2}{color; color of font for high entries if \code{incl_val} is
\code{TRUE}. \code{"white"} by default}

\item{font_thres}{numeric; values less than \code{font_thres} will be displayed
in \code{font_color1} if \code{incl_val} is \code{TRUE}. \code{mean(x)} by default}
}
\value{
Returns \code{ggplot2} visualization of matrix
}
\description{
Create a visualization of a matrix
}
\examples{
\dontrun{
library(ggplot2)

# get the data
set.seed(12)
data <- generateData()
X <- data$X
Z <- data$Z
interval <- data$interval
prec <- data$true_precision

# get overall and within interval sample sizes
n <- nrow(X)
n1 <- sum(interval == 1)
n2 <- sum(interval == 2)
n3 <- sum(interval == 3)

# visualize the distribution of the extraneous covariate
ggplot(data.frame(Z = Z, interval = as.factor(interval))) +
  geom_histogram(aes(Z, fill = interval), color = "black", bins = n \%/\% 5)

# visualize the true precision matrices in each of the intervals

# interval 1
matViz(prec[[1]], incl_val = TRUE) +
  ggtitle(paste0("True precision matrix, interval 1, observations 1,...,", n1))

# interval 2 (varies continuously with Z)
cat("\nInterval 2, observations ", n1 + 1, ",...,", n1 + n2, sep = "")
int2_mats <- prec[interval == 2]
int2_inds <- c(5, n2 \%/\% 2, n2 - 5)
lapply(int2_inds, function(j) matViz(int2_mats[[j]], incl_val = TRUE) +
         ggtitle(paste("True precision matrix, interval 2, observation", j + n1)))

# interval 3
matViz(prec[[length(prec)]], incl_val = TRUE) +
  ggtitle(paste0("True precision matrix, interval 3, observations ",
                 n1 + n2 + 1, ",...,", n1 + n2 + n3))

# fit the model and visualize the estimated graphs
(out <- covdepGE(X, Z))
plot(out)

# visualize the posterior inclusion probabilities for variables (1, 3) and (1, 2)
inclusionCurve(out, 1, 2)
inclusionCurve(out, 1, 3)
}
}
