% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{cramer_vonmises}
\alias{cramer_vonmises}
\title{Cramér-von-Mises criterion}
\usage{
cramer_vonmises(
  copula,
  theta,
  x,
  n_bootstrap = 1000,
  parameters = NULL,
  optim.method = "L-BFGS-B",
  optim.control = list(maxit = 100)
)
}
\arguments{
\item{copula}{\R object of class '\code{\linkS4class{cyl_copula}}' or
'\code{\linkS4class{Copula}}' (package '\pkg{copula}'.}

\item{theta}{\link[base]{numeric} \link[base]{vector} of angles
(measurements of a circular variable) or "circular" component of pseudo-observations.}

\item{x}{\link[base]{numeric} \link[base]{vector} of step lengths
(measurements of a linear variable) or "linear" component of pseudo-observations.}

\item{n_bootstrap}{\link[base]{integer} number of bootstrap replicates. If
\code{n_bootstrap} is smaller than 1, no p-value is calculated.}

\item{parameters}{\link[base]{vector} of \link[base]{character} strings
holding the names of the parameters to be optimized when using the bootstrap
procedure.
  These can be any parameters in \code{copula@parameters}. Default is to
  optimize the first 2 parameters. \code{parameters} has no effect if \code{copula}
  is of class '\code{\linkS4class{Copula}}' (package '\pkg{copula}'}

\item{optim.method}{\link[base]{character} string, optimizer used in
\code{\link[stats]{optim}()}, can be
 \code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"}, \code{"L-BFGS-B"},
 \code{"SANN"}, or \code{"Brent"}.}

\item{optim.control}{\link[base]{list} of additional controls passed to
\code{\link[stats]{optim}()}.}
}
\value{
A list of length 2 containing the Cramér-von Mises criterion and the p-value.
}
\description{
Calculate the Cramér-von-Mises criterion
with a p-value (via parametric bootstrapping) to assess the goodness of fit
of a parametric copula compared to the empirical copula of the data.
}
\details{
The Cramér-von Misses criterion is calculated as the sum of the squared
differences between the empirical copula and the parametric copula, \code{copula},
evaluated at the pseudo-observations obtained from \code{theta} and \code{x}.
If the bootstrap procedure is used, a random sample is drawn from \code{copula}
and converted to pseudo-observations. A new (set of) copula parameter(s) is then
fit to those pseudo-observations using maximum likelihood (function
\code{cylcop::\link[cylcop]{fit_cylcop_ml}()}).
}
\examples{
set.seed(1234)
sample <- rcylcop(100,cyl_cubsec(0.1, 0.1))

opt_cop <- fit_cylcop_ml(copula = cyl_quadsec(),
  theta = sample[,1],
  x = sample[,2],
  parameters = "a",
  start = 0
)$copula
cramer_vonmises(opt_cop,
  theta = sample[,1],
  x = sample[,2],
  n_bootstrap=5)

}
\references{
\insertRef{Genest2008}{cylcop}
}
