% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_rf.R
\name{reg_rf}
\alias{reg_rf}
\title{Random Forest for regression}
\usage{
reg_rf(attribute, nodesize = 1, ntree = 10, mtry = NULL)
}
\arguments{
\item{attribute}{attribute target to model building}

\item{nodesize}{node size}

\item{ntree}{number of trees}

\item{mtry}{number of attributes to build tree}
}
\value{
returns an object of class \code{reg_rf}obj
}
\description{
Creates a regression object that
uses the Random Forest method.
It wraps the randomForest library.
}
\examples{
data(Boston)
model <- reg_rf("medv", ntree=10)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, Boston)
train <- sr$train
test <- sr$test

model <- fit(model, train)

test_prediction <- predict(model, test)
test_predictand <- test[,"medv"]
test_eval <- evaluate(model, test_predictand, test_prediction)
test_eval$metrics
}
