% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_character.R
\name{as_character}
\alias{as_character}
\alias{as_character.haven_labelled_defined}
\alias{as.character.haven_labelled_defined}
\title{Coerce a defined vector to character}
\usage{
as_character(x, ...)

\method{as_character}{haven_labelled_defined}(x, preserve_attributes = FALSE, ...)

\method{as.character}{haven_labelled_defined}(x, ...)
}
\arguments{
\item{x}{A vector created with \code{\link[=defined]{defined()}}.}

\item{...}{Reserved for future use.}

\item{preserve_attributes}{Logical. If \code{TRUE}, retains \code{unit}, \code{concept}, and
\code{namespace} attributes. Defaults to \code{FALSE}.}
}
\value{
A character vector.
}
\description{
\code{as_character()} is the recommended method to convert a
\code{\link[=defined]{defined()}} vector to a character type. It is metadata-aware and
ensures that the underlying data is character before coercion.

Base R's \code{as.character()} method applied to \code{defined} vectors
simply strips the class and returns the values as a plain character vector.
This is equivalent to calling \code{\link[=as_character]{as_character()}} with \code{preserve_attributes = FALSE}.
}
\details{
If \code{preserve_attributes = TRUE}, the returned character vector retains
semantic metadata such as \code{unit}, \code{concept}, and \code{namespace}, though the
\code{"defined"} class itself is removed. If \code{preserve_attributes = FALSE}
(default), a plain character vector is returned with all attributes stripped.

For numeric-based \code{defined} vectors, \code{as_character()} throws an informative
error to avoid accidental coercion of non-character data.

Note: \code{as.character()} (base R) is supported but simply returns the raw
values, and does not preserve or warn about metadata loss.
}
\examples{
# Recommended use
fruits <- defined(c("apple", "avocado", "kiwi"), label = "Fruit", unit = "kg")
as_character(fruits, preserve_attributes = TRUE)

# Strip metadata
as_character(fruits, preserve_attributes = FALSE)

# Equivalent base R fallback
as.character(fruits)

}
\seealso{
\code{\link[=strip_defined]{strip_defined()}}, \code{\link[=as_numeric]{as_numeric()}}
}
