% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edl.R
\name{edl_download}
\alias{edl_download}
\title{download assets from earthdata over https using bearer tokens}
\usage{
edl_download(
  href,
  dest = basename(href),
  header = edl_set_token(),
  use_httr = TRUE,
  ...
)
}
\arguments{
\item{href}{the https URL of the asset}

\item{dest}{local destination}

\item{header}{the Authorization header (\verb{Bearer <token>}).  Will be
requested automatically if not provided.}

\item{use_httr}{logical, default TRUE. Should we use httr or base method?}

\item{...}{additional arguments to the \code{\link[utils:download.file]{utils::download.file()}} (ignored
if \code{use_httr=TRUE}).}
}
\value{
the \code{dest} path, invisibly
}
\description{
NOTE: This should be used primarily as a fallback mechanism!
EarthData Cloud resources are often best accessed directly over
HTTPS without download.  This allows subsets to be extracted instead
of downloading unnecessary bits.  Unfortunately, certain formats do
not support such HTTP-based range requests (e.g. HDF4), and require
the asset is downloaded to a local POSIX filesystem first.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
href <- lpdacc_example_url()
edl_download(href)
\dontshow{\}) # examplesIf}
}
