% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.sign.R
\name{InitErgmTerm.gwdelesf}
\alias{InitErgmTerm.gwdelesf}
\title{Geometrically weighted delayed edgewise shared friends}
\usage{
# binary: gwdelesf(decay, base, type = "OTP")
}
\arguments{
\item{decay}{Numeric decay parameter controlling weighting intensity. If \code{NULL}, raw counts are used.}

\item{base}{Character indicating which edges in the current network are used as the base:
`"+"` for positive ties or `"-"` for negative ties.}

\item{type}{Character specifying which shared partner pattern to use; one of
\code{"OTP"} (outgoing two-path),
\code{"ITP"} (incoming two-path),
\code{"RTP"} (reciprocated two-path),
\code{"OSP"} (outgoing shared partner),
\code{"ISP"} (incoming shared partner).}
}
\description{
This term calculates the number of shared friends based on the previous network.
It then applies a geometric transformation to these counts to reduce the influence of large counts.
Specifically, if the decay parameter \code{decay} is provided, the weighting function used is
\deqn{f(k; decay) = 1 - (1 - e^{-decay})^k,}{f(k; decay) = 1 - (1 - exp(-d))^k,}
where \code{k} is the count of shared partners and \code{decay} controls how quickly the weight decreases as counts increase.
If \code{decay} is no
}
\concept{delayed}
