% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blink.R
\name{blink}
\alias{blink}
\title{Your data in a blink of an eye}
\usage{
blink(x, va_to = "logmar", va_cols = NULL, iop_cols = NULL, fct_level = 0:4)
}
\arguments{
\item{x}{data frame}

\item{va_to}{to which VA notation (passed to \code{\link[=va]{va()}})}

\item{va_cols}{if specified, overruling automatic VA columns selection.
tidyselection supported}

\item{iop_cols}{if specified, overruling automatic IOP columns selection.
tidyselection supported}

\item{fct_level}{Remove columns for Summarizing when all unique values
fall into range. character or numeric vector, default \code{1:4}}
}
\value{
object of class \code{blink} and \code{list}. Class blink contains the
myopized data, count of patients and eyes,
and summaries for visual acuities and intraocular pressure.
}
\description{
\code{blink} summarizes your data tailored to the need of
ophthalmic research: It looks for VA and IOP columns and summarises those
with common statistics. In order to make it work, it requires specific
column naming - please see section "column names" and "data coding".
For more details how blink works, see \code{vignette("eye")}
}
\details{
\code{blink} is basically a wrapper around \link{myop}, \link{eyes} and \link{reveal}:
\itemize{
\item Duplicate rows are always removed
\item Column names are prepared for myopization (see \link{myop})
\item VA will always be converted to logmar
}
}
\section{Data coding}{

\itemize{
\item Only common codes supported:
\item \strong{eyes}: "r", "re", "od", "right" - or numeric coding r:l = 0:1 or 1:2
\item \strong{Visual acuity}: "VA", "BCVA", "Acuity"
\item \strong{Intraocular pressure}: "IOP", "GAT", "NCT", "pressure"
}
}

\section{Column name rules}{

\itemize{
\item No spaces!
\item Do not use numeric coding for eyes in column names
\item Separate eye and VA and IOP codes with \strong{underscores}
("bcva_l_preop", "VA_r", "left_va", "IOP_re")
\item Avoid separate VA or IOP codes if this is not actually containing
VA/ IOP data (e.g. "stableVA" instead of "stable_va", ChangeIOP instead
of "change_IOP")
\item Keep names short
\item Don't use underscores when you don't have to.
Consider each section divided by an underscore as a relevant
characteristic of your variable. ("preop" instead of "pre_op",
"VA" instead of "VA_ETDRS_Letters")
\item Use common codes for your patient column (see \link{eyes}, section Guessing)
(e.g., "pat", "patient" or "ID", ideally both: "patientID" or "patID")
\item \strong{Don't be too creative with your names!}
}
}

\section{Names examples}{

\strong{Good names}:

-\code{c("patid", "surgery_right", "iop_r_preop", "va_r_preop", "iop_r", "iop_l")}

\strong{OK names}

-\code{c("Id", "Eye", "BaselineAge", "VA_ETDRS_Letters", "InjectionNumber")}:
Names are long and there are two unnecessary underscore in the VA column.
Better just "VA"
-\code{c("id", "r",  "l")}: All names are commonly used (good!),
but which dimension of "r"/"l" are we exactly looking at?

\strong{Bad names} (\code{eye} will fail)
\itemize{
\item \code{c("id", "iopr", "iopl", "VAr", "VAl")}:
\code{eye} won't be able to recognize IOP and VA columns
\item \code{c("id", "iop_r", "iop_l", "stable_iop_r", "stable_iop_l")}:
\code{eye} \emph{may} wrongly identify the (probably logical) columns "stable_iop"
as columns containing IOP data. Better maybe: "stableIOP_l"
\item \code{c("person", "goldmann", "vision")}: \code{eye} will not recognize that at all
}
}

\section{tidy data}{

\strong{blink and myop work more reliably with clean data}
(any package will, really!).
\href{https://tidyr.tidyverse.org/articles/tidy-data.html}{clean data.}
}

\section{column removal}{

Done with \link{remCols}: Removes columns that only
contain values defined in \emph{fct_levels} or logicals from selected columns
(currently for both automatically and manually selected columns).
fct_levels are removed because they are likely categorical codes.
}

\examples{
library(eyedata)
blink(amd2)

messy_df <- data.frame( id = letters[1:3],
iop_r_preop = sample(21:23), iop_r_postop = sample(11:13),
iop_l_postop = sample(11:13), iop_l_preop = sample(31:33),
va_r_preop = sample(41:43),  va_l_preop = sample(41:43),
va_r_postop = sample(51:53), va_l_postop = sample(45:47)
)
blink(messy_df)
}
\seealso{
\href{https://tidyselect.r-lib.org/reference/language.html}{About tidyselection}.

How to rename your columns (two threads on stackoverflow.com):
\itemize{
\item \href{https://stackoverflow.com/questions/7531868/how-to-rename-a-single-column-in-a-data-frame}{Rename columns 1}
\item \href{https://stackoverflow.com/questions/20987295/rename-multiple-columns-by-names/59567220#59567220}{Rename columns 2}
}
}
