% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{abline_mfd}
\alias{abline_mfd}
\title{Add reference lines to all panels of the current multi-panel plot}
\usage{
abline_mfd(a = NULL, b = NULL, h = NULL, v = NULL, ...)
}
\arguments{
\item{a, b}{the intercept and slope, single values.}

\item{h}{the y-value(s) for horizontal line(s).}

\item{v}{the x-value(s) for vertical line(s).}

\item{...}{Further graphical parameters (e.g., \code{col}, \code{lty}, \code{lwd}).}
}
\description{
Calls \code{\link[graphics]{abline}} in every panel actually used by the most
recent call to \code{\link{plot.mfd}}.
}
\details{
The function relies on \code{plot.mfd} having stored the number of variables
in \code{options("last_mfd_nvar")}. It then loops over exactly that many
panels in the current layout.

Calls \code{\link[graphics]{abline}} in every panel actually used by the most
recent call to \code{\link{plot.mfd}}. Vertical and horizontal lines span
the full x- or y-range of each panel, even when scales differ.
}
