% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.R
\name{import_MultipleAlignment}
\alias{import_MultipleAlignment}
\title{Import MultipleAlignment Result}
\usage{
import_MultipleAlignment(filepath, format = "fasta", type = "DNA")
}
\arguments{
\item{filepath}{
    A character vector (of arbitrary length when reading, of length 1
    when writing) containing the paths to the files to read or write.
    Note that special values like \code{""} or \code{"|cmd"} (typically
    supported by other I/O functions in R) are not supported here. Also
    \code{filepath} cannot be a connection.
  }

\item{format}{
    Either \code{"fasta"} (the default), \code{stockholm}, or
    \code{"clustal"}.
  }

\item{type}{one of "DNA" and "Protein"}
}
\value{
object of DNAMultipleAlignment
}
\description{
import sequences algned results
}
\examples{
aliSeqPath <- system.file("extdata", "seqs.fa", package = "geneHapR")

geneSeqs <- import_MultipleAlignment(filepath = aliSeqPath,
                                     format = "fasta",
                                     type = "DNA")
geneSeqs <- import_MultipleAlignment(filepath = aliSeqPath,
                                     format = "fasta",
                                     type = "Protein")

}
