% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_labels}
\alias{GC_labels}
\title{Add Labels to Each Cluster in a GC Chart}
\usage{
GC_labels(
  GC_chart,
  label = NULL,
  show = TRUE,
  cluster = NULL,
  itemStyle = list(),
  ...
)
}
\arguments{
\item{GC_chart}{A `GC chart` object to which labels will be added.}

\item{label}{Character vector, logical, or NULL. Specific labels for the clusters.
If NULL and `GC_chart` has group names, those will be used as labels.}

\item{show}{Logical; controls the visibility of labels. Default is `TRUE`.}

\item{cluster}{Numeric or character vector or NULL; specifies which clusters should be labeled.
If NULL, labels will be applied to all clusters. Default is NULL.}

\item{itemStyle}{List, a list of styles to apply to individual items in the chart.}

\item{...}{Additional arguments for further customization of the labels.}
}
\value{
A `GC chart` object with updated label settings for each specified cluster.
}
\description{
This function adds labels to each cluster within a GC chart. It provides the
option to show or hide the labels and supports customization of label properties.
It can automatically pick up group names as labels from the `GC_chart` object if not provided.
}
\examples{
genes_data <- data.frame(
  start = c(10, 90, 130, 170, 210),
  end = c(40, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'B', 'B', 'A', 'C'),
  cluster = c(1, 1, 2, 2, 2)
)

# Add labels to all clusters
GC_chart(genes_data, cluster = "cluster", group = "group", height = "200px") \%>\%
GC_labels()

# Add labels and styling
GC_chart(genes_data, cluster = "cluster", group = "group", height = "200px") \%>\%
GC_labels(
 label = "group",
 show = TRUE,
 x = 0,
 y = 50,
 dy = "-1.2em",
 dx = "0em",
 rotate = 0,
 adjustLabels = TRUE, # Rotate labels to prevent overlap
 fontSize = "12px",
 fontStyle = "italic",
 fill = "black",
 fontFamily = "sans-serif",
 textAnchor = "middle",
 cursor = "default",
)

# Alter style of a specific label
GC_chart(genes_data, cluster = "cluster", group = "group", height = "200px") \%>\%
GC_labels(label = "group") \%>\%
GC_labels(
  cluster = 1,
  itemStyle = list(
    list(index = 0, fill = "red", fontSize = "14px", fontWeight = "bold")
  )
)

}
