% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-latex.R
\name{theme_latex}
\alias{theme_latex}
\alias{theme_showlatex}
\alias{theme_nolatex}
\alias{theme_hidelatex}
\title{Parse Labels w Latex Markup}
\usage{
theme_latex(value = TRUE)

theme_showlatex()

theme_nolatex()

theme_hidelatex()
}
\arguments{
\item{value}{logical as to whether to enable latex parsing or not}
}
\description{
A series of convenience functions that either enable or disable the use of the \code{\link{latex2exp}} package 
for parsing the various text elements using the \code{\link{TeX}} method. In many cases, by turning the latex parsing
on, this prevents confusing use of expressions to obtain greeks, superscripts, subscripts etc... Note that when 
latex parsing is enabled, this can override specific formatting directives from the element tree, see the third 
and fourth example below.
}
\examples{

#Demonstrate  without latex parsing
ggtern() + 
 theme_latex(FALSE) + 
 labs(title = '\\\\textit{Plot Title}')

#Same as before, but turn on the latex parsing
last_plot() + 
 theme_latex(TRUE)

#Demonstrate latex overriding the bold face
ggtern() + 
 labs(title = '\\\\textit{Plot Title}') + 
 theme_latex(TRUE) + 
 theme('plot.title' = element_text(face='bold'))

#Turn off latex parsing, bold title revealed
last_plot() + 
 theme_latex(FALSE)
 
}
\seealso{
\code{\link[latex2exp]{TeX}}
}
\author{
Nicholas Hamilton
}
