% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwfit.R
\name{coef.gkwfit}
\alias{coef.gkwfit}
\title{Extract Model Coefficients from a gkwfit Object}
\usage{
\method{coef}{gkwfit}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwfit"}, typically the result of a call to \code{\link{gkwfit}}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A named numeric vector containing the estimated coefficients for the
parameters of the specified GKw family distribution. The names correspond
to the parameter names (e.g., \code{"alpha"}, \code{"beta"}, etc.).
}
\description{
Extracts the estimated coefficients for the parameters of a model fitted by
\code{\link{gkwfit}}. This is an S3 method for the generic \code{\link[stats]{coef}} function.
}
\examples{
\donttest{
# Generate data and fit model
set.seed(2203)
y <- rgkw(50, alpha = 1.5, beta = 2.5, gamma = 1.2, delta = 0.3, lambda = 1.1)
fit <- gkwfit(data = y, family = "gkw", plot = FALSE)

# Extract all coefficients
params <- coef(fit)
print(params)

# Access specific parameters
alpha_est <- coef(fit)["alpha"]
lambda_est <- coef(fit)["lambda"]
cat("Estimated alpha:", alpha_est, "\n")
cat("Estimated lambda:", lambda_est, "\n")
}

}
\seealso{
\code{\link{gkwfit}}, \code{\link[stats]{coef}}, \code{\link{vcov.gkwfit}}, \code{\link{logLik.gkwfit}}
}
\author{
Lopes, J. E.
}
\keyword{methods}
\keyword{models}
