% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-inference.R
\name{BIC.gkwreg}
\alias{BIC.gkwreg}
\title{Bayesian Information Criterion for GKw Regression Models}
\usage{
\method{BIC}{gkwreg}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwreg"}, typically obtained from
\code{\link{gkwreg}}.}

\item{...}{Optionally more fitted model objects.}
}
\value{
If only one object is provided, returns a numeric value with the BIC.
If multiple objects are provided, returns a data frame with columns \code{df}
and \code{BIC}, with rows named according to the object names in the call.
}
\description{
Calculates the Bayesian Information Criterion (BIC), also known as the
Schwarz Information Criterion (SIC), for fitted Generalized Kumaraswamy
regression models.
}
\details{
The BIC is computed as:
\deqn{BIC = -2\ell(\hat{\theta}) + p \cdot \log(n)}
where \eqn{\ell(\hat{\theta})} is the maximized log-likelihood, \eqn{p} is
the number of estimated parameters, and \eqn{n} is the sample size.

When multiple objects are provided, a data frame comparing all models is
returned. Lower BIC values indicate better models. BIC penalizes model
complexity more heavily than AIC, particularly for large samples, and tends
to favor more parsimonious models.

The BIC can be derived from a Bayesian perspective as an approximation to
the logarithm of the Bayes factor, under certain regularity conditions and
assuming uniform priors.
}
\examples{
\donttest{
# Load example data
data(GasolineYield)

# Fit competing models
fit1 <- gkwreg(yield ~ batch, data = GasolineYield, family = "kw")
fit2 <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")
fit3 <- gkwreg(yield ~ temp, data = GasolineYield, family = "kw")

# Calculate BIC for single model
BIC(fit1)

# Compare multiple models (with proper names)
BIC(fit1, fit2, fit3)
}

}
\references{
Schwarz, G. (1978). Estimating the dimension of a model.
\emph{The Annals of Statistics}, \strong{6}(2), 461--464.
\doi{10.1214/aos/1176344136}
}
\seealso{
\code{\link{gkwreg}}, \code{\link{logLik.gkwreg}}, \code{\link{AIC.gkwreg}}
}
\author{
Lopes, J. E.
}
