% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{cooks.distance.gsl_nls}
\alias{cooks.distance.gsl_nls}
\title{Calculate Cook's distance}
\usage{
\method{cooks.distance}{gsl_nls}(model, ...)
}
\arguments{
\item{model}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
Numeric vector of Cook's distance values similar to \code{\link[stats]{cooks.distance}}.
}
\description{
Returns Cook's distance values from a fitted \code{"gsl_nls"} object based on the estimated
variance-covariance matrix of the model parameters.
}
\examples{
## data
set.seed(1)
n <- 25
xy <- data.frame(
 x = (1:n) / n,
 y = 2.5 * exp(-1.5 * (1:n) / n) + rnorm(n, sd = 0.1)
)
## model
obj <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))

cooks.distance(obj)
}
\seealso{
\code{\link[stats]{cooks.distance}}
}
