% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_chow.R
\name{hcp_chow}
\alias{hcp_chow}
\title{Chow test method}
\usage{
hcp_chow()
}
\value{
\code{hcp_chow} object
}
\description{
Change-point detection method that focus on identifying structural changes  \url{doi:10.18637/jss.v007.i02}.
It wraps the Fstats and breakpoints implementation available in the strucchange library.
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_changepoints)

#Using simple example
dataset <- examples_changepoints$simple
head(dataset)

# setting up change point method
model <- hcp_chow()

# fitting the model
model <- fit(model, dataset$serie)

# execute the detection method
detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
