/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5FDros3_H
#define H5FDros3_H
#ifdef H5_HAVE_ROS3_VFD
#define H5FD_ROS3 (H5FDperform_init(H5FD_ros3_init))
#define H5FD_ROS3_VALUE H5_VFD_ROS3
#else
#define H5FD_ROS3       (H5I_INVALID_HID)
#define H5FD_ROS3_VALUE H5_VFD_INVALID
#endif
#ifdef H5_HAVE_ROS3_VFD
#define H5FD_CURR_ROS3_FAPL_T_VERSION 1
#define H5FD_ROS3_MAX_REGION_LEN 32
#define H5FD_ROS3_MAX_SECRET_ID_LEN 128
#define H5FD_ROS3_MAX_SECRET_KEY_LEN 128
#define H5FD_ROS3_MAX_SECRET_TOK_LEN 4096
typedef struct H5FD_ros3_fapl_t {
    int32_t version;
    hbool_t authenticate;
    char    aws_region[H5FD_ROS3_MAX_REGION_LEN + 1];
    char    secret_id[H5FD_ROS3_MAX_SECRET_ID_LEN + 1];
    char    secret_key[H5FD_ROS3_MAX_SECRET_KEY_LEN + 1];
} H5FD_ros3_fapl_t;
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5FD_ros3_init(void);
H5_DLL herr_t H5Pget_fapl_ros3(hid_t fapl_id, H5FD_ros3_fapl_t *fa_out);
H5_DLL herr_t H5Pset_fapl_ros3(hid_t fapl_id, const H5FD_ros3_fapl_t *fa);
H5_DLL herr_t H5Pget_fapl_ros3_token(hid_t fapl_id, size_t size, char *token);
H5_DLL herr_t H5Pset_fapl_ros3_token(hid_t fapl_id, const char *token);
#ifdef __cplusplus
}
#endif
#endif
#endif
