% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{exdat_ozone}
\alias{exdat_ozone}
\title{PM2.5 exposure and COPD incidence in Switzerland}
\format{
\code{exdat_ozone}
\describe{
  \item{pollutant}{\eqn{O_3}}
  \item{exposure}{mean exposure level in the exposure category}
  \item{exp_unit}{unit of the exposure}
  \item{proportion_population_exposed}{proportion of the total population exposed to each exposure category}
  \item{mortality_copd_tota_yearl}{mortality due to chronic obstructive pulmonary disease (ICD-10 J40-44)}
  \item{rr_central}{central relative risk estimate}
  \item{rr_lower}{lower 95\% confidence interval bound of the relative risk estimate}
  \item{rr_upper}{upper 95\% confidence interval bound of the relative risk estimate}
  \item{rr_increment}{exposure increment in \eqn{\mu g/m^3} for which the relative risk estimates are valid}
  \item{cutoff}{cutoff level below which no health effects are attributable to the exposure}
  \item{erf_shape}{shape of the exposure-response function}
  \item{exposure_type}{exposure type}
  \item{rr_source}{source of the relative risk estimates}
  \item{country}{country}
  \item{year}{year of the data}
}
}
\source{
Real-world data
}
\usage{
data(exdat_ozone)
}
\description{
This tibble contains modelled ozone (\eqn{O_3}) exposure and chronic obstructive pulmonary disease (COPD) incidence data from the Germany in 2016.
}
\author{
Alberto Castro & Axel Luyten
}
\keyword{internal}
