% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportFunc.R
\name{calc_areas}
\alias{calc_areas}
\title{Function to calculate areas of classes within a categorical raster}
\usage{
calc_areas(x)
}
\arguments{
\item{x}{An object of class RasterLayer.}
}
\value{
A data frame with one column representing the values of the classes of the raster and the other variable representing corresponding areas in Ha.
}
\description{
This function takes a categorical raster object and calculates the areas covered by each class within the raster.
}
\details{
The raster package's "area()" function normally returns the same raster where cell values have been replaced by their areas in Square Km.
Using this function, the values of all cells of same class are aggregated and the raster is transformed into a data frame.
If the CRS of the input raster is projected, then the area is calculated by multiplying the resolution of the raster by the count of cells for each class.
}
\examples{
calc_areas(lulcYanze)
}
\seealso{
\code{\link{area}}

\code{\link{aggregate}}

\code{\link{values}}
}
\author{
Faustin Gashakamba
}
