% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_from_prufer}
\alias{make_from_prufer}
\alias{from_prufer}
\title{Create an undirected tree graph from its Prüfer sequence}
\usage{
make_from_prufer(prufer)

from_prufer(...)
}
\arguments{
\item{prufer}{The Prüfer sequence to convert into a graph}

\item{...}{Passed to \code{make_from_prufer()}}
}
\value{
A graph object.
}
\description{
\code{make_from_prufer()} creates an undirected tree graph from its Prüfer
sequence.
}
\details{
The Prüfer sequence of a tree graph with n labeled vertices is a sequence of
n-2 numbers, constructed as follows. If the graph has more than two vertices,
find a vertex with degree one, remove it from the tree and add the label of
the vertex that it was connected to to the sequence. Repeat until there are
only two vertices in the remaining graph.
}
\examples{

g <- make_tree(13, 3)
to_prufer(g)
}
\seealso{
\code{\link[=to_prufer]{to_prufer()}} to convert a graph into its Prüfer sequence

Other trees: 
\code{\link{is_forest}()},
\code{\link{is_tree}()},
\code{\link{sample_spanning_tree}()},
\code{\link{to_prufer}()}
}
\concept{trees}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Generators.html#igraph_from_prufer}{\code{from_prufer()}}.}

