% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEvents.R
\name{getEvents}
\alias{getEvents}
\title{Return a dataframe that contains all events and kpi values for a set of given
match IDs}
\usage{
getEvents(matches, token, include_kpis = TRUE, include_set_pieces = FALSE)
}
\arguments{
\item{matches}{'IMPECT' match ID or a list of match IDs}

\item{token}{bearer token}

\item{include_kpis}{include KPIs in event data}

\item{include_set_pieces}{include additional set piece data in event data}
}
\value{
a dataframe containing all events and kpi values for a set of given
match IDs
}
\description{
Return a dataframe that contains all events and kpi values for a set of given
match IDs
}
\examples{
# Toy example: this will error quickly (no API token)
try(events <- getEvents(
  matches = c(0, 1),
  token = "invalid",
  include_kpis = T,
  include_set_pieces = F
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
events <- getEvents(
  matches = c(84248, 158150),
  token = "yourToken",
  include_kpis = T,
  include_set_pieces = F
)
}
}
