# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

srm_model_sparse <- function(X, y, Loss, Penalty, Algorithm, NnzStopNum, G_ncols, G_nrows, Lambda2Max, Lambda2Min, PartialSort, MaxIters, rtol, atol, ActiveSet, ActiveSetNum, MaxNumSwaps, ScaleDownFactor, ScreenSize, LambdaU, Lambdas, ExcludeFirstK, Intercept, withBounds, Lows, Highs) {
    .Call('_inferCSN_srm_model_sparse', PACKAGE = 'inferCSN', X, y, Loss, Penalty, Algorithm, NnzStopNum, G_ncols, G_nrows, Lambda2Max, Lambda2Min, PartialSort, MaxIters, rtol, atol, ActiveSet, ActiveSetNum, MaxNumSwaps, ScaleDownFactor, ScreenSize, LambdaU, Lambdas, ExcludeFirstK, Intercept, withBounds, Lows, Highs)
}

srm_model_dense <- function(X, y, Loss, Penalty, Algorithm, NnzStopNum, G_ncols, G_nrows, Lambda2Max, Lambda2Min, PartialSort, MaxIters, rtol, atol, ActiveSet, ActiveSetNum, MaxNumSwaps, ScaleDownFactor, ScreenSize, LambdaU, Lambdas, ExcludeFirstK, Intercept, withBounds, Lows, Highs) {
    .Call('_inferCSN_srm_model_dense', PACKAGE = 'inferCSN', X, y, Loss, Penalty, Algorithm, NnzStopNum, G_ncols, G_nrows, Lambda2Max, Lambda2Min, PartialSort, MaxIters, rtol, atol, ActiveSet, ActiveSetNum, MaxNumSwaps, ScaleDownFactor, ScreenSize, LambdaU, Lambdas, ExcludeFirstK, Intercept, withBounds, Lows, Highs)
}

srm_model_cv_sparse <- function(X, y, Loss, Penalty, Algorithm, NnzStopNum, G_ncols, G_nrows, Lambda2Max, Lambda2Min, PartialSort, MaxIters, rtol, atol, ActiveSet, ActiveSetNum, MaxNumSwaps, ScaleDownFactor, ScreenSize, LambdaU, Lambdas, nfolds, seed, ExcludeFirstK, Intercept, withBounds, Lows, Highs) {
    .Call('_inferCSN_srm_model_cv_sparse', PACKAGE = 'inferCSN', X, y, Loss, Penalty, Algorithm, NnzStopNum, G_ncols, G_nrows, Lambda2Max, Lambda2Min, PartialSort, MaxIters, rtol, atol, ActiveSet, ActiveSetNum, MaxNumSwaps, ScaleDownFactor, ScreenSize, LambdaU, Lambdas, nfolds, seed, ExcludeFirstK, Intercept, withBounds, Lows, Highs)
}

srm_model_cv_dense <- function(X, y, Loss, Penalty, Algorithm, NnzStopNum, G_ncols, G_nrows, Lambda2Max, Lambda2Min, PartialSort, MaxIters, rtol, atol, ActiveSet, ActiveSetNum, MaxNumSwaps, ScaleDownFactor, ScreenSize, LambdaU, Lambdas, nfolds, seed, ExcludeFirstK, Intercept, withBounds, Lows, Highs) {
    .Call('_inferCSN_srm_model_cv_dense', PACKAGE = 'inferCSN', X, y, Loss, Penalty, Algorithm, NnzStopNum, G_ncols, G_nrows, Lambda2Max, Lambda2Min, PartialSort, MaxIters, rtol, atol, ActiveSet, ActiveSetNum, MaxNumSwaps, ScaleDownFactor, ScreenSize, LambdaU, Lambdas, nfolds, seed, ExcludeFirstK, Intercept, withBounds, Lows, Highs)
}

R_matrix_column_get_dense <- function(mat, col) {
    .Call('_inferCSN_R_matrix_column_get_dense', PACKAGE = 'inferCSN', mat, col)
}

R_matrix_column_get_sparse <- function(mat, col) {
    .Call('_inferCSN_R_matrix_column_get_sparse', PACKAGE = 'inferCSN', mat, col)
}

R_matrix_rows_get_dense <- function(mat, rows) {
    .Call('_inferCSN_R_matrix_rows_get_dense', PACKAGE = 'inferCSN', mat, rows)
}

R_matrix_rows_get_sparse <- function(mat, rows) {
    .Call('_inferCSN_R_matrix_rows_get_sparse', PACKAGE = 'inferCSN', mat, rows)
}

R_matrix_vector_schur_product_dense <- function(mat, u) {
    .Call('_inferCSN_R_matrix_vector_schur_product_dense', PACKAGE = 'inferCSN', mat, u)
}

R_matrix_vector_schur_product_sparse <- function(mat, u) {
    .Call('_inferCSN_R_matrix_vector_schur_product_sparse', PACKAGE = 'inferCSN', mat, u)
}

R_matrix_vector_divide_dense <- function(mat, u) {
    .Call('_inferCSN_R_matrix_vector_divide_dense', PACKAGE = 'inferCSN', mat, u)
}

R_matrix_vector_divide_sparse <- function(mat, u) {
    .Call('_inferCSN_R_matrix_vector_divide_sparse', PACKAGE = 'inferCSN', mat, u)
}

R_matrix_column_sums_dense <- function(mat) {
    .Call('_inferCSN_R_matrix_column_sums_dense', PACKAGE = 'inferCSN', mat)
}

R_matrix_column_sums_sparse <- function(mat) {
    .Call('_inferCSN_R_matrix_column_sums_sparse', PACKAGE = 'inferCSN', mat)
}

R_matrix_column_dot_dense <- function(mat, col, u) {
    .Call('_inferCSN_R_matrix_column_dot_dense', PACKAGE = 'inferCSN', mat, col, u)
}

R_matrix_column_dot_sparse <- function(mat, col, u) {
    .Call('_inferCSN_R_matrix_column_dot_sparse', PACKAGE = 'inferCSN', mat, col, u)
}

R_matrix_column_mult_dense <- function(mat, col, u) {
    .Call('_inferCSN_R_matrix_column_mult_dense', PACKAGE = 'inferCSN', mat, col, u)
}

R_matrix_column_mult_sparse <- function(mat, col, u) {
    .Call('_inferCSN_R_matrix_column_mult_sparse', PACKAGE = 'inferCSN', mat, col, u)
}

R_matrix_normalize_dense <- function(mat_norm) {
    .Call('_inferCSN_R_matrix_normalize_dense', PACKAGE = 'inferCSN', mat_norm)
}

R_matrix_normalize_sparse <- function(mat_norm) {
    .Call('_inferCSN_R_matrix_normalize_sparse', PACKAGE = 'inferCSN', mat_norm)
}

R_matrix_center_dense <- function(mat, X_normalized, intercept) {
    .Call('_inferCSN_R_matrix_center_dense', PACKAGE = 'inferCSN', mat, X_normalized, intercept)
}

R_matrix_center_sparse <- function(mat, X_normalized, intercept) {
    .Call('_inferCSN_R_matrix_center_sparse', PACKAGE = 'inferCSN', mat, X_normalized, intercept)
}

asMatrix <- function(rp, cp, z, nrows, ncols) {
    .Call('_inferCSN_asMatrix', PACKAGE = 'inferCSN', rp, cp, z, nrows, ncols)
}

asMatrixParallel <- function(rp, cp, z, nrows, ncols) {
    .Call('_inferCSN_asMatrixParallel', PACKAGE = 'inferCSN', rp, cp, z, nrows, ncols)
}

#' @title Filter and sort matrix
#'
#' @param network_matrix The matrix of network weight.
#' @param regulators Regulators list.
#' @param targets Targets list.
#'
#' @return Filtered and sorted matrix
#' @export
#'
#' @examples
#' data("example_matrix")
#' network_table <- inferCSN(example_matrix)
#' network_matrix <- table_to_matrix(network_table)
#' filter_sort_matrix(network_matrix)[1:6, 1:6]
#'
#' filter_sort_matrix(
#'   network_matrix,
#'   regulators = c("g1", "g2"),
#'   targets = c("g3", "g4")
#' )
filter_sort_matrix <- function(network_matrix, regulators = NULL, targets = NULL) {
    .Call('_inferCSN_filter_sort_matrix', PACKAGE = 'inferCSN', network_matrix, regulators, targets)
}

#' @title Switch matrix to network table
#'
#' @param network_matrix The matrix of network weight.
#' @param regulators Character vector of regulator names to filter by.
#' @param targets Character vector of target names to filter by.
#' @param threshold The threshold for filtering weights based on absolute values, defaults to 0.
#'
#' @return Network table
#' @export
#'
#' @examples
#' data("example_matrix")
#' network_table <- inferCSN(example_matrix)
#' network_matrix <- table_to_matrix(network_table)
#' network_table_new <- matrix_to_table(network_matrix)
#' head(network_table)
#' head(network_table_new)
#' identical(
#'   network_table,
#'   network_table_new
#' )
#'
#' matrix_to_table(
#'   network_matrix,
#'   threshold = 0.8
#' )
#'
#' matrix_to_table(
#'   network_matrix,
#'   regulators = c("g1", "g2"),
#'   targets = c("g3", "g4")
#' )
#'
matrix_to_table <- function(network_matrix, regulators = NULL, targets = NULL, threshold = 0.0) {
    .Call('_inferCSN_matrix_to_table', PACKAGE = 'inferCSN', network_matrix, regulators, targets, threshold)
}

prepare_calculate_metrics <- function(network_table, ground_truth) {
    .Call('_inferCSN_prepare_calculate_metrics', PACKAGE = 'inferCSN', network_table, ground_truth)
}

#' @title Format network table
#'
#' @param network_table The weight data table of network.
#' @param regulators Regulators list.
#' @param targets Targets list.
#' @param abs_weight Logical value, default is *`TRUE`*,
#' whether to perform absolute value on weights,
#' and when set `abs_weight` to *`TRUE`*,
#' the output of weight table will create a new column named `Interaction`.
#'
#' @md
#' @return Formated network table
#' @export
#'
#' @examples
#' data("example_matrix")
#' network_table <- inferCSN(example_matrix)
#'
#' network_format(
#'   network_table,
#'   regulators = "g1"
#' )
#'
#' network_format(
#'   network_table,
#'   regulators = "g1",
#'   abs_weight = FALSE
#' )
#'
#' network_format(
#'   network_table,
#'   targets = "g3"
#' )
#'
#' network_format(
#'   network_table,
#'   regulators = c("g1", "g3"),
#'   targets = c("g3", "g5")
#' )
network_format <- function(network_table, regulators = NULL, targets = NULL, abs_weight = TRUE) {
    .Call('_inferCSN_network_format', PACKAGE = 'inferCSN', network_table, regulators, targets, abs_weight)
}

#' @title Split indices.
#'
#' @description An optimised version of split for the special case of splitting row indices into groups.
#'
#' @param group Integer indices
#' @param n The largest integer (may not appear in index).
#' This is hint: if the largest value of \code{group} is bigger than \code{n},
#' the output will silently expand.
#' @useDynLib inferCSN
#' @return A list of vectors of indices.
#'
#' @references
#' https://github.com/hadley/plyr/blob/d57f9377eb5d56107ba3136775f2f0f005f33aa3/src/split-numeric.cpp#L20
#' @export
#' @examples
#' split_indices(sample(10, 100, rep = TRUE))
#' split_indices(sample(10, 100, rep = TRUE), 10)
split_indices <- function(group, n = 0L) {
    .Call('_inferCSN_split_indices', PACKAGE = 'inferCSN', group, n)
}

#' @title Switch network table to matrix
#'
#' @param network_table The weight data table of network.
#' @param regulators Regulators list.
#' @param targets Targets list.
#'
#' @return Weight matrix
#' @export
#'
#' @examples
#' data("example_matrix")
#' network_table <- inferCSN(example_matrix)
#' head(network_table)
#'
#' table_to_matrix(network_table)[1:6, 1:6]
#'
#' table_to_matrix(
#'   network_table,
#'   regulators = c("g1", "g2"),
#'   targets = c("g3", "g4")
#' )
table_to_matrix <- function(network_table, regulators = NULL, targets = NULL) {
    .Call('_inferCSN_table_to_matrix', PACKAGE = 'inferCSN', network_table, regulators, targets)
}

#' @title Weight sift
#' @description Remove edges with smaller weights in the reverse direction.
#'
#' @param table A data frame with three columns: "regulator", "target", and "weight".
#'
#' @export
#'
#' @examples
#' data("example_matrix")
#' network_table <- inferCSN(example_matrix)
#' weight_sift(network_table) |> head()
weight_sift <- function(table) {
    .Call('_inferCSN_weight_sift', PACKAGE = 'inferCSN', table)
}

