% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_multnom.R
\name{Multinom}
\alias{Multinom}
\title{Multinom outcome for kDGLM models}
\usage{
Multinom(p, data, offset = as.matrix(data)^0, base.class = NULL)
}
\arguments{
\item{p}{character: a vector with the name of the linear predictor associated with the probability of each category (except the base one, which is assumed to be the last).}

\item{data}{vector: Values of the observed data.}

\item{offset}{vector: The offset at each observation. Must have the same shape as data.}

\item{base.class}{character or integer: The name or index of the base class. Default is to use the last column of data.}
}
\value{
A object of the class dlm_distr
}
\description{
Creates an outcome with Multinomial distribution with the chosen parameters.
}
\details{
For evaluating the posterior parameters, we use the method proposed in \insertCite{ArtigokParametrico;textual}{kDGLM}.

For the details about the implementation see  \insertCite{ArtigoPacote;textual}{kDGLM}.
}
\examples{

structure <- (
  polynomial_block(p = 1, order = 2, D = 0.95) +
    harmonic_block(p = 1, period = 12, D = 0.975) +
    noise_block(p = 1, R1 = 0.1) +
    regression_block(p = chickenPox$date >= as.Date("2013-09-01"))
  # Vaccine was introduced in September of 2013
) * 4

outcome <- Multinom(p = structure$pred.names, data = chickenPox[, c(2, 3, 4, 6, 5)])
fitted.data <- fit_model(structure, chickenPox = outcome)
summary(fitted.data)
plot(fitted.data, plot.pkg = "base")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{fit_model}}

Other auxiliary functions for a creating outcomes: 
\code{\link{Gamma}()},
\code{\link{Normal}()},
\code{\link{Poisson}()},
\code{\link{summary.dlm_distr}()}
}
\concept{auxiliary functions for a creating outcomes}
