% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{zero_sum_prior}
\alias{zero_sum_prior}
\title{Zero sum prior}
\usage{
zero_sum_prior(
  block,
  var.index = 1:block$n,
  weights = rep(1, length(var.index))
)
}
\arguments{
\item{block}{dlm_block object: The structural block.}

\item{var.index}{integer: The index of the variables from which to set the prior.}

\item{weights}{numeric: A vector indicating which linear transformation of the data is 0 with probability 1. Default is equivalent to a zero-sum restriction.}
}
\value{
A dlm_block object with the desired prior.
}
\description{
Defines the prior of a structural block to be such that the latent states sum zero with probability one.
}
\details{
The covariance matrix of the evolution and the drift parameter are also altered to guarantee that the zero sum condition will always hold.
The discount factor must be the same for all variables whose prior is being modified.
For the details about the implementation see \insertCite{ArtigoPacote;textual}{kDGLM}.
}
\examples{

polynomial_block(mu = 1, D = 0.95) |>
  block_mult(5) |>
  zero_sum_prior()

}
\references{
\insertAllCited{}
}
\seealso{
Other auxiliary functions for defining priors.: 
\code{\link{CAR_prior}()},
\code{\link{joint_prior}()}
}
\concept{auxiliary functions for defining priors.}
