% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FixationFilterFunctions.R
\name{trim_fixations}
\alias{trim_fixations}
\title{Adjust the onset and offset of fixations to avoid misclassification of saccade samples as belonging to fixations}
\usage{
trim_fixations(
  fixations,
  gaze,
  xcol = "x.raw",
  ycol = "y.raw",
  threshold = 3,
  one_degree = 40
)
}
\arguments{
\item{fixations}{Data frame with fixations to trim. The data frame must include the variables 'firstline' (index of first row in the sample-by-sample data belonging to
each fixation), 'lastline' (index of last row in the sample-by-sample data belonging to each fixation). The function works with the fixation output from kollaR event classification algorithms
the fixation)}

\item{gaze}{Data frame with sample-to-sample data. Must include timestamps in milliseconds specified by the variable timestamp, and X and Y coordinates specified by the
parameters 'xcol' and 'ycol'.}

\item{xcol}{Variable in the sample-to-sample data frame where X coordinates (before event classification) are found}

\item{ycol}{Variable in the sample-to-sample data frame where X coordinates (before event classification) are found}

\item{threshold}{Threshold for highest accepted distance from fixation center in MADs from the median. Default 3. If NA, just remove NAs
at the onset and offest of fixation but ignore deviations from fixation center}

\item{one_degree}{One degree of the visual field in the units of the X and Y coordinates (which is typically pixels or degrees of the visual field)}
}
\value{
data frame with fixations after adjustment of onset and offset
}
\description{
Adjust the onset and offset of all fixations in a data frame (The function adjust_fixation_timing does this for a single fixation).

Shrink the period classified as a fixation by removing samples at the onset and offset with excessive differences from the fixation center or which are missing (X or Y are NA).
This reduces the risk that samples belonging to saccades are misclassified as belonging to a fixation. Please note that this procedure is included by default in the
event classification algorithm 'alogorithm_i2mc' (see documentation for this function for details)

The procedure starts by calculating the median (MD) and MAD of the absolute distances from the fixation center of all included samples. The fixation onset
is shifted forwards to the first sample with a distance to the fixation center under t* MAD + MD where t is specified by the input parameter threshold.
Analogously, fixation offset is shifted backwards to the last included sample with distance to the fixation center under t* MAD + MD

trim_fixations will look for variables called 'fixation.algorithm' and 'threshold' in the data frame 'fixations'. These columns are produced by kollaR event classification
algorithms. If they are found, they will be transfered to the output data frame.
}
