% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.lqr.R
\name{summary.lqr}
\alias{summary.lqr}
\title{Summary of an \code{lqr} object}
\usage{
\method{summary}{lqr}(object, ...)
}
\arguments{
\item{object}{an \code{lqr} object}

\item{...}{not used}
}
\value{
Return an object of \code{\link{class}} \code{summary.lqr}.
This is a list of summary statistics for the fitted linear quantile regression model given in \code{object}, with the following elements:

\item{fix}{a matrix with estimates, standard errors, Z statistics, and p-values for the regression coefficients}
\item{scale}{the scale parameter}
\item{sigma.e}{the standard deviation of error terms}
\item{lk}{the log-likelihood}
\item{npar}{the total number of model parameters}
\item{aic}{the AIC value}
\item{bic}{the BIC value}
\item{qtl}{the estimated quantile}
\item{nobs}{the total number of observations}
\item{model}{the estimated model}
\item{call}{the matched call}
}
\description{
Summary method for the \code{\link{class}} \code{lqr}
}
