/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.propagation;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.propagation.listener.PropagationEngineListener;
import choco.kernel.solver.search.measure.FailMeasure;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.set.SetVar;
import java.util.Arrays;

public abstract class AbstractPropagationEngine
implements PropagationEngine {
    public final Solver solver;
    protected final FailMeasure failMeasure;
    protected PropagationEngineListener[] propagationEngineListeners = new PropagationEngineListener[8];
    protected int pelIdx = 0;
    protected final ContradictionException reuseException;

    public AbstractPropagationEngine(Solver solver) {
        this.solver = solver;
        this.reuseException = ContradictionException.build();
        this.failMeasure = new FailMeasure(this);
    }

    public final Solver getSolver() {
        return this.solver;
    }

    @Override
    public final FailMeasure getFailMeasure() {
        return this.failMeasure;
    }

    @Override
    public void clear() {
        this.failMeasure.safeReset();
        this.pelIdx = 0;
        Arrays.fill(this.propagationEngineListeners, 0, 0, null);
    }

    @Override
    public final void raiseContradiction(Object cause) throws ContradictionException {
        this.reuseException.set(cause);
        for (int i = 0; i < this.pelIdx; ++i) {
            this.propagationEngineListeners[i].contradictionOccured(this.reuseException);
        }
        throw this.reuseException;
    }

    @Override
    public final void raiseContradiction(Object cause, int move) throws ContradictionException {
        this.reuseException.set(cause, move);
        for (int i = 0; i < this.pelIdx; ++i) {
            this.propagationEngineListeners[i].contradictionOccured(this.reuseException);
        }
        throw this.reuseException;
    }

    @Override
    @Deprecated
    public final void raiseContradiction(int cidx, Var variable, SConstraint cause) throws ContradictionException {
        if (cidx >= 0) {
            this.reuseException.set(variable.getConstraintVector().get(cidx));
        } else {
            this.reuseException.set(variable);
        }
        for (int i = 0; i < this.pelIdx; ++i) {
            this.propagationEngineListeners[i].contradictionOccured(this.reuseException);
        }
        throw this.reuseException;
    }

    @Override
    public final void addPropagationEngineListener(PropagationEngineListener listener) {
        if (this.pelIdx == this.propagationEngineListeners.length) {
            PropagationEngineListener[] tmp = this.propagationEngineListeners;
            this.propagationEngineListeners = new PropagationEngineListener[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.propagationEngineListeners, 0, this.pelIdx);
        }
        this.propagationEngineListeners[this.pelIdx++] = listener;
    }

    @Override
    public final void removePropagationEngineListener(PropagationEngineListener listener) {
        int i;
        for (i = 0; i < this.pelIdx && this.propagationEngineListeners[i] != listener; ++i) {
        }
        if (i < this.pelIdx) {
            System.arraycopy(this.propagationEngineListeners, i + 1, this.propagationEngineListeners, i, this.pelIdx - i);
            --this.pelIdx;
        }
    }

    @Override
    public boolean containsPropagationListener(PropagationEngineListener listener) {
        int i;
        for (i = 0; i < this.pelIdx && this.propagationEngineListeners[i] != listener; ++i) {
        }
        return i < this.pelIdx;
    }

    @Override
    public final void postInstInt(IntDomainVar v, SConstraint constraint, boolean forceAwake) {
        this.postEvent(v, 3, constraint, forceAwake);
    }

    @Override
    public final void postUpdateInf(IntDomainVar v, SConstraint constraint, boolean forceAwake) {
        this.postEvent(v, 0, constraint, forceAwake);
    }

    @Override
    public final void postUpdateSup(IntDomainVar v, SConstraint constraint, boolean forceAwake) {
        this.postEvent(v, 1, constraint, forceAwake);
    }

    @Override
    public final void postRemoveVal(IntDomainVar v, int x, SConstraint constraint, boolean forceAwake) {
        this.postEvent(v, 2, constraint, forceAwake);
    }

    @Override
    public final void postUpdateInf(RealVar v, SConstraint constraint, boolean forceAwake) {
        this.postEvent(v, 0, constraint, forceAwake);
    }

    @Override
    public final void postUpdateSup(RealVar v, SConstraint constraint, boolean forceAwake) {
        this.postEvent(v, 1, constraint, forceAwake);
    }

    @Override
    public final void postRemEnv(SetVar v, SConstraint constraint, boolean forceAwake) {
        this.postEvent(v, 0, constraint, forceAwake);
    }

    @Override
    public final void postAddKer(SetVar v, SConstraint constraint, boolean forceAwake) {
        this.postEvent(v, 1, constraint, forceAwake);
    }

    @Override
    public final void postInstSet(SetVar v, SConstraint constraint, boolean forceAwake) {
        this.postEvent(v, 2, constraint, forceAwake);
    }
}

