% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgss-package.R
\docType{package}
\name{mgss-package}
\alias{mgss}
\alias{mgss-package}
\title{mgss: A Matrix-Free Multigrid Preconditioner for Spline Smoothing}
\description{
Data smoothing with penalized splines is a popular method and is well established for one- or two-dimensional covariates. The extension to multiple covariates is straightforward but suffers from exponentially increasing memory requirements and computational complexity. This toolbox provides a matrix-free implementation of a conjugate gradient (CG) method for the regularized least squares problem resulting from tensor product B-spline smoothing with multivariate and scattered data. It further provides matrix-free preconditioned versions of the CG-algorithm where the user can choose between a simpler diagonal preconditioner and an advanced geometric multigrid preconditioner. The main advantage is that all algorithms are performed matrix-free and therefore require only a small amount of memory. For further detail see Siebenborn & Wagner (2021).
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/SplineSmoothing/MGSS}
}

}
\author{
\strong{Maintainer}: Martin Siebenborn \email{martin.siebenborn@uni-hamburg.de} [copyright holder]

Authors:
\itemize{
  \item Julian Wagner \email{juwagn89@gmail.com} [copyright holder]
}

}
\keyword{internal}
